package hiro.yoshioka.sql.params;

import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.Serializable;

public class SSHProperties implements Serializable, Cloneable {
	private static final long serialVersionUID = 3141534388803157250L;
	public String definition_name;

	public String hostname = StringUtil.EMPTY_STRING;
	public String username = StringUtil.EMPTY_STRING;
	public String password = StringUtil.EMPTY_STRING;
	//
	// or "~/.ssh/id_dsa"
	public File keyfile;
	// will be ignored if not needed
	public String keyfilePass = StringUtil.EMPTY_STRING;

	// -----------------------------------------------
	// LocalPortForwarder
	// -----------------------------------------------
	public int local_port;
	public String host_to_connect = StringUtil.EMPTY_STRING;
	public int port_to_connect;

	// -----------------------------------------------
	// RemotePortForwarding
	// -----------------------------------------------
	public String bindAddress = StringUtil.EMPTY_STRING;
	public int bindPort;
	public String targetAddress = StringUtil.EMPTY_STRING;
	public int targetPort;

	public SSHProperties() {
	}

	public SSHProperties(String definition_name) {
		this.definition_name = definition_name;
	}
}
