package hiro.yoshioka.sql.params;

import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;

public class DBUserPass implements Serializable {
	public String db = StringUtil.EMPTY_STRING;
	public String user = StringUtil.EMPTY_STRING;
	public String pass = StringUtil.EMPTY_STRING;

	public DBUserPass() {
	}

	public DBUserPass(String db, String user, String pass) {
		this.db = StringUtil.nvl(db);
		this.user = StringUtil.nvl(user);
		this.pass = StringUtil.nvl(pass);
	}

	public DBUserPass(String user, String pass) {
		this(null, user, pass);
	}

	public String getDb() {
		return db;
	}

	public void setDb(String db) {
		this.db = db;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPass() {
		return pass;
	}

	public void setPass(String pass) {
		this.pass = pass;
	}

	@Override
	public String toString() {
		return String.format("DB[%s] User[%s] Pass[%s]", db, user, pass);
	}

}
