package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.params.ConnectionProperties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MirroringRequest extends TwoDatabasesRequest {
	static final String[] TITLE = { "RESOURCE", "TYPE", "NAME", "COMMENT",
			"RESULT", "COUNT", "THROWABLE" };

	public boolean cascade;
	public boolean dropSchema;
	public boolean dropTable;
	public boolean richTextConvertHtml;

	private Set<SQL_TYPES_CONVERT_MODE> sqlTypesConvertSet = new HashSet<MirroringRequest.SQL_TYPES_CONVERT_MODE>();

	public MirroringRequest(ConnectionProperties originalConnectionProperties,
			ConnectionProperties targetConnectionProperties) {
		super(SQLOperationType.RESOURCE_MIRRORING,
				originalConnectionProperties, targetConnectionProperties);
		setRDH(new ResultSetDataHolder2(TITLE, null, DatabaseType.UNKNOWN));
		sqlTypesConvertSet.add(SQL_TYPES_CONVERT_MODE.BOOLEAN_TO_NUMBER);
	}

	@Override
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("PATTERN [S/T/P] [");
		// buf.append(getSchemaP()).append("/");
		// buf.append(getTableP()).append("/");
		// buf.append(getProcedureP());
		buf.append("]");
		return buf.toString();
	}

	public enum SQL_TYPES_CONVERT_MODE {
		/** BOOLEAN(TRUE) TO NUMBER(1) */
		BOOLEAN_TO_NUMBER("NUMBER(1)", "NUMBER(1)"),
		/** BOOLEAN(TRUE) TO CHAR('1') */
		BOOLEAN_TO_CHAR_1("CHAR('1')", "CHAR(1)"),
		/** BOOLEAN(TRUE) TO CHAR('T') */
		BOOLEAN_TO_CHAR_T("CHAR('T')", "CHAR(1)");

		public static final List<SQL_TYPES_CONVERT_MODE> BOOLEAN_LIST;
		static {
			BOOLEAN_LIST = new ArrayList<MirroringRequest.SQL_TYPES_CONVERT_MODE>();
			BOOLEAN_LIST.add(BOOLEAN_TO_NUMBER);
			BOOLEAN_LIST.add(BOOLEAN_TO_CHAR_1);
			BOOLEAN_LIST.add(BOOLEAN_TO_CHAR_T);
		}
		private String label;
		private String column_type_ddl;

		private SQL_TYPES_CONVERT_MODE(String label, String type_ddl) {
			this.label = label;
			this.column_type_ddl = type_ddl;
		}

		public String getLabel() {
			return label;
		}

		public String getColumnTypeDdl() {
			return column_type_ddl;
		}

		public static SQL_TYPES_CONVERT_MODE getBooleanCnv(
				Set<SQL_TYPES_CONVERT_MODE> sqlTypesConvertSet) {
			for (SQL_TYPES_CONVERT_MODE mode : sqlTypesConvertSet) {
				if (BOOLEAN_LIST.contains(mode)) {
					return mode;
				}
			}
			return null;
		}
	}

	public Set<SQL_TYPES_CONVERT_MODE> getSqlTypesConvertSet() {
		return sqlTypesConvertSet;
	}

	public void addConvertMode(SQL_TYPES_CONVERT_MODE data) {
		if (sqlTypesConvertSet.contains(data)) {
			return;
		}
		if (SQL_TYPES_CONVERT_MODE.BOOLEAN_LIST.contains(data)) {// boolean
			for (SQL_TYPES_CONVERT_MODE deleteMode : SQL_TYPES_CONVERT_MODE.BOOLEAN_LIST) {
				sqlTypesConvertSet.remove(deleteMode);
			}
		}
		sqlTypesConvertSet.add(data);
	}

}