package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.OutPutParameter;
import hiro.yoshioka.sql.params.Parameter;
import hiro.yoshioka.util.SQLDataType;

import java.util.ArrayList;

public class CallRequest extends Request {
	String fSQLStatement;

	ArrayList<Parameter> fInputParameterList = new ArrayList<Parameter>();

	ArrayList<OutPutParameter> fOutPutParameterList = new ArrayList<OutPutParameter>();

	public CallRequest(String sql_statement,
			ConnectionProperties connectionProperties) {
		super(SQLOperationType.PREPARED_CALL, connectionProperties);
		fSQLStatement = sql_statement;
	}

	public Parameter[] getInputParameters() {
		return fInputParameterList.toArray(new Parameter[fInputParameterList
				.size()]);
	}

	public String[] getOutPutValues() {
		String[] ret = new String[fOutPutParameterList.size()];
		for (int i = 0; i < fOutPutParameterList.size(); i++) {
			ret[i] = fOutPutParameterList.get(i).getResult();
		}
		return ret;
	}

	public OutPutParameter[] getOutPutParameters() {
		return fOutPutParameterList
				.toArray(new OutPutParameter[fOutPutParameterList.size()]);
	}

	public void addParameter(int index, BindObject value) {
		fInputParameterList.add(new Parameter(index, value));
	}

	public void addOutPutParameter(int index, SQLDataType type) {
		fOutPutParameterList.add(new OutPutParameter(index, type));
	}

	public void addOutPutParameter(String name, int index, SQLDataType type,
			int columnType) {
		fOutPutParameterList.add(new OutPutParameter(name, index, type,
				columnType));
	}

	public String getSQLStatement() {
		return fSQLStatement;
	}

}