package hiro.yoshioka.sql;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;

interface IAbsBasicSQL extends ISQLOpetaionTarget {

	abstract boolean load(File f);

	abstract boolean save(File f) throws IOException;

	void setMakeBlobData(boolean makeblob);

	boolean isMakeBlobData();

	boolean connect(ConnectionProperties properties) throws SQLException;

	boolean close() throws SQLException;

	Date getLatestRequestTime();

	abstract void addConnectionListner(SqlBasicListener listner);

	abstract void removeConnetionListener(SqlBasicListener listner);

	abstract void addTracsactionListner(SqlTransactionListener listener);

	abstract void removeTracsactionListner(SqlTransactionListener listener);

	ResultSetDataHolder renameField(IDBColumn before, String afterName)
			throws SQLException;

	abstract DBRoot getRoot();

	String getDefaultSchemaName();

	boolean createDatabase(String name, Properties properties)
			throws SQLException;

	boolean dropDatabase(String name) throws SQLException;

	boolean createUser(String name, Properties properties) throws SQLException;

	boolean dropUser(String name) throws SQLException;

	abstract void setRoot(DBRoot root);

	abstract DBRoot getCopyRoot();

	abstract Set<String> getSchemas();

	Set<String> getTables(String schema);

	List<String> getTablePrimaryKeys(String catalog, String schema, String table)
			throws SQLException;

	abstract ResultSetDataHolder getProcedures(String name);

	abstract boolean isCapturing();

	abstract boolean canDoOperation(SQLOperationType operation);

	abstract void setBuildTimeStamp(String format);

	abstract void setBuildDate(String format);

	// ----------------------------------------------------------------
	// MIRRORING
	// ----------------------------------------------------------------
	boolean supportResultSet();

	boolean existsSchema(String name) throws SQLException;

	void setTableColumns(String schema, IDBTable table) throws SQLException;
}