package hiro.yoshioka.sql.resource.notes;

import hiro.yoshioka.sql.notes.AbsNotesRunner;
import hiro.yoshioka.util.SQLDataType;

public enum ItemType {

	ERRORITEM(256),

	// Field descriptor #5 I
	UNAVAILABLE(512),

	// Field descriptor #5 I
	TEXT(1280),

	// Field descriptor #5 I
	NUMBERS(768),

	// Field descriptor #5 I
	DATETIMES(1024),

	// Field descriptor #5 I
	NAMES(1074),

	// Field descriptor #5 I
	READERS(1075),

	// Field descriptor #5 I
	AUTHORS(1076),

	// Field descriptor #5 I
	RICHTEXT(1),

	// Field descriptor #5 I
	USERID(1792),

	// Field descriptor #5 I
	FORMULA(1536),

	// Field descriptor #5 I
	COLLATION(2),

	// Field descriptor #5 I
	NOTEREFS(4),

	// Field descriptor #5 I
	NOTELINKS(7),

	// Field descriptor #5 I
	ATTACHMENT(1084),

	// Field descriptor #5 I
	OTHEROBJECT(1085),

	// Field descriptor #5 I
	UNKNOWN(0),

	// Field descriptor #5 I
	ICON(6),

	// Field descriptor #5 I
	SIGNATURE(8),

	// Field descriptor #5 I
	USERDATA(14),

	// Field descriptor #5 I
	EMBEDDEDOBJECT(1090),

	// Field descriptor #5 I
	QUERYCD(15),

	// Field descriptor #5 I
	ACTIONCD(16),

	// Field descriptor #5 I
	ASSISTANTINFO(17),

	// Field descriptor #5 I
	VIEWMAPDATA(18),

	// Field descriptor #5 I
	VIEWMAPLAYOUT(19),

	// Field descriptor #5 I
	LSOBJECT(20),

	// Field descriptor #5 I
	HTML(21),

	// Field descriptor #5 I
	MIME_PART(25),

	// Field descriptor #5 I
	RFC822TEXT(1282),

	// This definition is only DXL FieldType
	datetime(88888888),
	// This definition is only DXL FieldType
	number(88888888),
	// This definition is only DXL FieldType
	keyword(88888888),

	UNKOWN(-99999999);

	private int typeId;

	private ItemType(int typeId) {
		this.typeId = typeId;
	}

	public static ItemType parse(int typeId) {
		for (ItemType target : values()) {
			if (target.typeId == typeId) {
				return target;
			}
		}

		return UNKNOWN;
	}

	public int getTypeId() {
		return typeId;
	}

	public SQLDataType getSQLTypes() {
		return getSQLTypes(this);
	}

	public int getSize(String itemName) {
		switch (this) {
		case ACTIONCD:
		case ASSISTANTINFO:
		case AUTHORS:
		case COLLATION:
		case NAMES:
		case ATTACHMENT:
			return 512;
		case DATETIMES:
		case datetime:
			return 0;
		case NUMBERS:
		case number:
			return 32;
		case USERID:
		case READERS:
			return 1024;
		default:
			if (AbsNotesRunner.UniversalID.equals(itemName)) {
				return 32;
			} else if (AbsNotesRunner.Form.equals(itemName)) {
				return 128;
			} else if (itemName.endsWith("URL")) {
				return 1024;
			}
			return 4000;
		}
	}

	private SQLDataType getSQLTypes(ItemType type) {
		switch (type) {
		case ACTIONCD:
		case ASSISTANTINFO:
		case AUTHORS:
		case COLLATION:
			return SQLDataType.VARCHAR;
		case ATTACHMENT:
			return SQLDataType.VARCHAR;
		case datetime:
		case DATETIMES:
			return SQLDataType.TIMESTAMP;
		case USERID:
		case READERS:
			return SQLDataType.VARCHAR;
		case RICHTEXT:
			return SQLDataType.CLOB;
		default:
			return SQLDataType.VARCHAR;
		}
	}

	public static ItemType parseByName(String trim) {
		for (ItemType type : values()) {
			if (type.name().equalsIgnoreCase(trim)) {
				return type;
			}
		}
		return ItemType.UNKOWN;
	}

	public String getSQLTypeName() {
		switch (getSQLTypes()) {
		case TIMESTAMP:
			return "TIMESTAMP";
		}
		return "VARCHAR";
	}
}
