package hiro.yoshioka.ast.sql.notes.util;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.mongo.util.Sql2MongoVisitor;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.oracle.util.BindCheckSQLNodeVisitor;
import hiro.yoshioka.ast.sql.oracle.util.FoldingSQLNodeVisitor;
import hiro.yoshioka.ast.sql.oracle.util.WolfParserUtil;
import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.sql.resource.notes.NotesDBTable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;

public class WolfNotesParserUtil extends WolfParserUtil {

	public WolfNotesParserUtil(File file) throws FileNotFoundException {
		super(file);
	}

	public WolfNotesParserUtil(String string) {
		super(string);
	}

	public AbsSQLParser createParser(StringReader reader) {
		return new WolfNotesSQLParser(reader);
	}

	public AbsSQLParser createParser(FileInputStream stream) {
		return new WolfNotesSQLParser(stream);
	}

	public static String getSearchFormQuery(NotesDBTable table) {
		if (table.hasAlias()) {
			return String.format("Form=\"%s\" ", table.getAlias());
		} else {
			return String.format("Form=\"%s\" ", table.getName());
		}
	}

	public static void main(String[] args) {
		String sql = "SELECT  $REF,dbname,Synonym,AppSpecID,NHDIDS,Context ,Subject,Book_1,Book  FROM \"IBM Lotus Notes 8.5.1 Help (Basic Configuration)\".Topic1 WHERE Context = 'fram_what_new_80x_r'";
		WolfNotesParserUtil util = new WolfNotesParserUtil(sql);
		if (util.parse()) {

			System.out.println("table=" + util.getFirstTable());
			System.out.println("parent=" + util.getFirstTable().getParent());
			System.out.println("where=" + util.getDML());
			System.out.println("------------------------------");

			Sql2MongoVisitor visitor = new Sql2MongoVisitor(sql);
			visitor.visit((SimpleNode) util.getRoot(), null);
			System.out.println("db:" + visitor.getDatabase());
			System.out.println("col:" + visitor.getCollection());
			if (visitor.needsRetry()) {
				sql = sql.replaceAll(visitor.getCollection(), visitor
						.getCollection().replace('.', '_'));
				util = new WolfNotesParserUtil(sql);
				util.parse();
				visitor = new Sql2MongoVisitor(sql);
				visitor.visit((SimpleNode) util.getRoot(), null);
			}
			System.out.println(visitor.getQueryUsedToSearch());
			System.out.println(visitor.getReturnFields());

			System.out.println("------------------------------");
			util.dumpNodes();
		}
	}

	public BindInfo[] binds() {
		if (!fParser.nodeCreated()) {
			return null;
		}

		BindCheckSQLNodeVisitor visitor = new BindCheckSQLNodeVisitor(
				getFirstTable());
		visitor.visit((SimpleNode) getRoot(), null);
		return (BindInfo[]) visitor.v.toArray(new BindInfo[0]);
	}

	@Override
	public AbsSimpleNode[] getFoldingNodes() {
		if (!fParser.nodeCreated()) {
			return null;
		}
		FoldingSQLNodeVisitor visitor = new FoldingSQLNodeVisitor();
		visitor.visit((SimpleNode) getRoot(), null);
		return (AbsSimpleNode[]) visitor.v.toArray(new AbsSimpleNode[0]);
	}

}
