package hiro.yoshioka.sql.resource;

import java.util.Map;
import java.util.TreeMap;

public class DBExportedKeyIndex extends DBConstraint {
	private static final long serialVersionUID = 999920140126456L;
  String fUpdateRule;

  String fDeleteRule;

  IDBTable fPKDBTable;

  IDBTable fFKDBTable;

  Map fColomnsMap = new TreeMap();

  public DBExportedKeyIndex(DBConstraintRoot root) {
    super(root);
  }

  public void setTable(IDBTable pktable, IDBTable fktable) {
    fPKDBTable = pktable;
    fFKDBTable = fktable;
  }

  /**
   * @param str_column
   */
  public void putColumn(IDBColumn pkColumn, IDBColumn fkColumn) {
    fColomnsMap.put(pkColumn, fkColumn);
  }

  /**
   * @param string
   */
  public void setUpdateRule(String string) {
    fUpdateRule = string;
  }

  /**
   * @param string
   */
  public void setDeleteRule(String string) {
    fDeleteRule = string;
  }

  public String getResourceKey(){
  	return fPKDBTable.getParent().getUName() + ":" + getName();
  }
  
  public String toString() {
    StringBuffer buf = new StringBuffer();

    buf.append(fPKDBTable.getParent().getName());
    buf.append(":");
    buf.append(fPKDBTable.getName());
    buf.append("  ");
    if (!fPKDBTable.getParent().equals(fFKDBTable.getParent())) {
      buf.append(fFKDBTable.getParent().getName());
      buf.append(":");
    }
    buf.append(fFKDBTable.getName());
    buf.append(" REF Columns");
    buf.append(fColomnsMap);

    return buf.toString();
  }
}