/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WebServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = -63348112220078595L;
    private Container container;
    private Config config;
    private List<RouteMapping> mappings = new ArrayList<RouteMapping>();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String configText = servletConfig.getInitParameter("config");
        if (configText == null) {
            configText = "";
        }
        net.arnx.jsonic.JSON json = new net.arnx.jsonic.JSON();
        try {
            this.config = json.parse((CharSequence)configText, this.getConfigClass());
            Class containerClass = Container.class;
            if (this.config.container != null) {
                this.config.container = this.config.container.replaceFirst("^(\\Qnet.arnx.jsonic.web.\\E)(.+Container)", "$1extension.$2");
                containerClass = this.findClass(this.config.container);
            }
            this.container = json.parse((CharSequence)configText, containerClass);
            this.container.init(this);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (this.config.processor == null) {
            this.config.processor = JSON.class;
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (this.config.mappings != null) {
            for (Map.Entry<String, String> entry : this.config.mappings.entrySet()) {
                this.mappings.add(new RouteMapping(entry.getKey(), entry.getValue(), this.config.definitions));
            }
        }
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                c = Class.forName(name, true, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                c = Class.forName(name);
            }
        }
        return c;
    }

    protected Class<? extends Config> getConfigClass() {
        return Config.class;
    }

    protected Route preprocess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RouteMapping m;
        String uri = request.getContextPath().equals("/") ? request.getRequestURI() : request.getRequestURI().substring(request.getContextPath().length());
        Route route = null;
        Iterator<RouteMapping> i$ = this.mappings.iterator();
        while (i$.hasNext() && (route = (m = i$.next()).matches(request, uri)) == null) {
        }
        if (route == null) {
            response.sendError(404, "Not Found");
            return null;
        }
        String method = route.getMethod();
        if (!(method.equals("GET") || method.equals("POST") || method.equals("PUT") || method.equals("DELETE"))) {
            response.sendError(403, "Method Not Allowed");
            return null;
        }
        this.container.debug("Route found: " + request.getMethod() + " " + uri);
        return route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.container.start(request, response);
        try {
            Route route = this.preprocess(request, response);
            if (route == null) {
                return;
            }
            if (route.isRpcMode()) {
                response.addHeader("Allow", "POST");
                response.sendError(405, "Method Not Allowd");
            } else {
                this.doREST(route, request, response);
            }
        }
        finally {
            this.container.end(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.container.start(request, response);
        try {
            Route route = this.preprocess(request, response);
            if (route == null) {
                return;
            }
            if (route.isRpcMode()) {
                this.doRPC(route, request, response);
            } else {
                this.doREST(route, request, response);
            }
        }
        finally {
            this.container.end(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.container.start(request, response);
        try {
            Route route = this.preprocess(request, response);
            if (route == null) {
                return;
            }
            if (route.isRpcMode()) {
                response.addHeader("Allow", "POST");
                response.sendError(405, "Method Not Allowed");
            } else {
                this.doREST(route, request, response);
            }
        }
        finally {
            this.container.end(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.container.start(request, response);
        try {
            Route route = this.preprocess(request, response);
            if (route == null) {
                return;
            }
            if (route.isRpcMode()) {
                response.addHeader("Allow", "POST");
                response.sendError(405, "Method Not Allowed");
            } else {
                this.doREST(route, request, response);
            }
        }
        finally {
            this.container.end(request, response);
        }
    }

    protected void doRPC(Route route, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        net.arnx.jsonic.JSON json = null;
        try {
            json = this.config.processor.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        json.setLocale(request.getLocale());
        RpcRequest req = null;
        Object result = null;
        int errorCode = 0;
        String errorMessage = null;
        Throwable throwable = null;
        try {
            req = json.parse((Reader)request.getReader(), RpcRequest.class);
            if (req == null || req.method == null || req.params == null) {
                throwable = new IllegalArgumentException("Request is empty.");
                errorCode = -32600;
                errorMessage = "Invalid Request.";
            } else {
                int delimiter = req.method.lastIndexOf(46);
                if (delimiter <= 0 && delimiter + 1 == req.method.length()) {
                    throw new NoSuchMethodException(req.method);
                }
                Object component = this.container.getComponent(route.getComponentClass(req.method.substring(0, delimiter)));
                if (component == null) {
                    throw new NoSuchMethodException("Method not found: " + req.method);
                }
                json.setContext(component);
                result = this.invoke(json, component, req.method.substring(delimiter + 1), req.params);
            }
        }
        catch (ClassNotFoundException e) {
            this.container.debug("Class Not Found.", e);
            throwable = e;
            errorCode = -32601;
            errorMessage = "Method not found.";
        }
        catch (NoSuchMethodException e) {
            this.container.debug("Method Not Found.", e);
            throwable = e;
            errorCode = -32601;
            errorMessage = "Method not found.";
        }
        catch (JSONException e) {
            this.container.debug("Fails to parse JSON.", e);
            throwable = e;
            if (e.getErrorCode() == 250) {
                errorCode = -32602;
                errorMessage = "Invalid params.";
            } else {
                errorCode = -32700;
                errorMessage = "Parse error.";
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.container.debug("Fails to invoke method.", e);
            throwable = cause;
            if (cause instanceof IllegalStateException || cause instanceof UnsupportedOperationException) {
                errorCode = -32601;
                errorMessage = "Method not found.";
            } else if (cause instanceof IllegalArgumentException) {
                errorCode = -32602;
                errorMessage = "Invalid params.";
            } else {
                errorCode = -32603;
                errorMessage = cause.getMessage();
            }
        }
        catch (Exception e) {
            this.container.error("Internal error occurred.", e);
            throwable = e;
            errorCode = -32603;
            errorMessage = "Internal error.";
        }
        if (req != null && req.method != null && req.params != null && req.id == null) {
            response.setStatus(202);
            return;
        }
        response.setContentType("application/json");
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        res.put("result", result);
        if (errorCode == 0) {
            res.put("error", null);
        } else {
            LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
            error.put("code", errorCode);
            error.put("message", errorMessage);
            error.put("data", throwable);
            res.put("error", error);
        }
        res.put("id", req != null ? req.id : null);
        PrintWriter writer = response.getWriter();
        json.setContext(result);
        json.setPrettyPrint(this.container.isDebugMode());
        json.format(res, writer);
    }

    protected void doREST(Route route, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String methodName = route.getMethod().toLowerCase();
        int status = 200;
        String callback = null;
        if ("GET".equals(route.getMethod())) {
            methodName = "find";
            callback = route.getParameter("callback");
        } else if ("POST".equals(route.getMethod())) {
            methodName = "create";
            status = 201;
        } else if ("PUT".equals(route.getMethod())) {
            methodName = "update";
        } else if ("DELETE".equals(route.getMethod())) {
            methodName = "delete";
        }
        net.arnx.jsonic.JSON json = null;
        try {
            json = this.config.processor.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        json.setLocale(request.getLocale());
        Object res = null;
        try {
            Object component = this.container.getComponent(route.getComponentClass(null));
            if (component == null) {
                response.sendError(404, "Not Found");
                return;
            }
            List<Map<?, ?>> params = null;
            if (!route.hasJSONContent()) {
                params = new ArrayList(1);
                params.add(route.getParameterMap());
            } else {
                Object o = json.parse(request.getReader());
                if (o instanceof List) {
                    params = (List)o;
                    if (params.isEmpty()) {
                        params = new ArrayList(1);
                        params.add(route.getParameterMap());
                    } else if (params.get(0) instanceof Map) {
                        params.set(0, route.mergeParameterMap((Map)params.get(0)));
                    }
                } else if (o instanceof Map) {
                    params = new ArrayList(1);
                    params.add(route.mergeParameterMap((Map)o));
                } else {
                    throw new IllegalArgumentException("failed to convert parameters from JSON.");
                }
            }
            json.setContext(component);
            res = this.invoke(json, component, methodName, params);
        }
        catch (ClassNotFoundException e) {
            this.container.debug("Class Not Found.", e);
            response.sendError(404, "Not Found");
            return;
        }
        catch (NoSuchMethodException e) {
            this.container.debug("Method Not Found.", e);
            response.sendError(404, "Not Found");
            return;
        }
        catch (JSONException e) {
            this.container.debug("Fails to parse JSON.", e);
            response.sendError(400, "Bad Request");
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.container.debug(cause.toString(), cause);
            if (cause instanceof IllegalStateException || cause instanceof UnsupportedOperationException) {
                response.sendError(404, "Not Found");
                return;
            }
            if (cause instanceof Error) {
                response.sendError(500, "Internal Server Error");
                return;
            }
            response.setStatus(400);
            res = cause;
        }
        catch (Exception e) {
            this.container.error("Internal error occurred.", e);
            response.sendError(500, "Internal Server Error");
            return;
        }
        response.setContentType(callback != null ? "text/javascript" : "application/json");
        if (res == null || res instanceof CharSequence || res instanceof Boolean || res instanceof Number || res instanceof Date) {
            if (status != 201) {
                status = 204;
            }
            response.setStatus(status);
        } else {
            PrintWriter writer = response.getWriter();
            json.setPrettyPrint(this.container.isDebugMode());
            if (callback != null) {
                ((Writer)writer).append(callback).append("(");
            }
            json.format(res, writer);
            if (callback != null) {
                ((Writer)writer).append(");");
            }
        }
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    protected Object[] preinvoke(Object target, Object ... params) {
        return params;
    }

    protected Object invoke(net.arnx.jsonic.JSON json, Object o, String methodName, List<?> args) throws Exception {
        if (args == null) {
            args = Collections.emptyList();
        }
        methodName = WebServiceServlet.toLowerCamel(methodName);
        Class<?> c = o.getClass();
        Method init = null;
        Method method = null;
        Type[] paramTypes = null;
        Method destroy = null;
        boolean illegalInit = false;
        boolean illegalDestroy = false;
        for (Method m : c.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.isSynthetic() || m.isBridge()) continue;
            if (m.getName().equals(this.container.init)) {
                if (m.getParameterTypes().length == 0 && m.getReturnType().equals(Void.TYPE)) {
                    init = m;
                    continue;
                }
                illegalInit = true;
                continue;
            }
            if (m.getName().equals(this.container.destroy)) {
                if (m.getParameterTypes().length == 0 && m.getReturnType().equals(Void.TYPE)) {
                    destroy = m;
                    continue;
                }
                illegalDestroy = true;
                continue;
            }
            if (!m.getName().equals(methodName)) continue;
            Type[] pTypes = m.getGenericParameterTypes();
            if (args.size() > Math.max(1, pTypes.length)) continue;
            if (method == null || Math.abs(args.size() - pTypes.length) < Math.abs(args.size() - paramTypes.length)) {
                method = m;
                paramTypes = pTypes;
                continue;
            }
            if (pTypes.length != paramTypes.length) continue;
            throw new IllegalStateException("too many methods found: " + this.toPrintString(c, methodName, args));
        }
        if (method == null || this.container.limit(c, method)) {
            throw new NoSuchMethodException("method missing: " + this.toPrintString(c, methodName, args));
        }
        if (this.container.isDebugMode() && init == null && illegalInit) {
            this.container.debug("Notice: init method must have no arguments.");
        }
        if (this.container.isDebugMode() && destroy == null && illegalDestroy) {
            this.container.debug("Notice: destroy method must have no arguments.");
        }
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = json.convert(i < args.size() ? args.get(i) : null, (Type)paramTypes[i]);
        }
        if (init != null) {
            if (this.container.isDebugMode()) {
                this.container.debug("Execute: " + this.toPrintString(c, init.getName(), null));
            }
            init.invoke(o, new Object[0]);
        }
        if (this.container.isDebugMode()) {
            this.container.debug("Execute: " + this.toPrintString(c, methodName, args));
        }
        params = this.preinvoke(o, params);
        Object ret = method.invoke(o, params);
        ret = this.postinvoke(o, ret);
        if (destroy != null) {
            if (this.container.isDebugMode()) {
                this.container.debug("Execute: " + this.toPrintString(c, destroy.getName(), null));
            }
            destroy.invoke(o, new Object[0]);
        }
        return ret;
    }

    protected Object postinvoke(Object target, Object result) {
        return result;
    }

    private String toPrintString(Class<?> c, String methodName, List<?> args) {
        StringBuilder sb = new StringBuilder(c.getName());
        sb.append('#').append(methodName).append('(');
        if (args != null) {
            String str = JSON.encode(args);
            sb.append(str, 1, str.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    private static String toLowerCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(0)) && Character.isLowerCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    static class ByteBuilder {
        private int length = 0;
        private byte[] array;

        public ByteBuilder() {
            this(1024);
        }

        public ByteBuilder(int length) {
            this.array = new byte[length];
        }

        public void append(int c) {
            this.append((byte)c);
        }

        public void append(char c) {
            this.append((byte)c);
        }

        public void append(byte b) {
            if (this.length + 1 > this.array.length) {
                byte[] newArray = new byte[(int)((double)this.array.length * 1.5)];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                this.array = newArray;
            }
            this.array[this.length++] = b;
        }

        public void append(byte[] bytes) {
            this.append(bytes, 0, bytes.length);
        }

        public void append(byte[] bytes, int offset, int len) {
            if (this.length + bytes.length > this.array.length) {
                byte[] newArray = new byte[(int)((double)(this.array.length + bytes.length) * 1.5)];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                this.array = newArray;
            }
            System.arraycopy(bytes, offset, this.array, this.length, len);
            this.length += len;
        }

        public boolean startsWith(String str) {
            if (this.length < str.length()) {
                return false;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == this.array[i]) continue;
                return false;
            }
            return true;
        }

        public boolean endsWith(String str) {
            if (this.length < str.length()) {
                return false;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(str.length() - i - 1) == this.array[this.length - i - 1]) continue;
                return false;
            }
            return true;
        }

        public boolean matches(String str) {
            if (this.length != str.length()) {
                return false;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == this.array[i]) continue;
                return false;
            }
            return true;
        }

        public byte byteAt(int pos) {
            return this.array[pos];
        }

        public int indexOf(char c) {
            for (int i = 0; i < this.length; ++i) {
                if (this.array[i] != c) continue;
                return i;
            }
            return -1;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int length() {
            return this.length;
        }

        public String substring(int start, int end, String encoding) throws UnsupportedEncodingException {
            return new String(this.array, start, end - start, encoding);
        }

        public String substring(int start, String encoding) throws UnsupportedEncodingException {
            return new String(this.array, start, this.length - start, encoding);
        }

        public String toString(String encoding) throws UnsupportedEncodingException {
            return new String(this.array, 0, this.length, encoding);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Route {
        private static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        private String target;
        private String method;
        private int contentLength = 0;
        private Map<Object, Object> params;
        private boolean isRpcMode;

        public Route(HttpServletRequest request, String target, Map<String, Object> params) throws IOException {
            this.target = target;
            this.params = params;
            if ("rpc".equalsIgnoreCase(this.getParameter("class"))) {
                this.isRpcMode = true;
                this.method = request.getMethod().toUpperCase();
            } else {
                String m;
                if (request.getQueryString() != null) {
                    this.parseQueryString(new ByteArrayInputStream(request.getQueryString().getBytes("US-ASCII")), request.getCharacterEncoding());
                }
                if (!request.getMethod().equalsIgnoreCase("GET")) {
                    this.contentLength = request.getContentLength();
                    Map<String, String> options = Route.parseHeaderLine(request.getContentType());
                    String contentType = options.get(null);
                    if (this.contentLength > 0 && contentType != null && contentType.equals("application/x-www-form-urlencoded")) {
                        this.parseQueryString((InputStream)request.getInputStream(), request.getCharacterEncoding());
                        this.contentLength = 0;
                    }
                }
                if ((m = this.getParameter("_method")) == null) {
                    m = request.getMethod();
                }
                this.method = m.toUpperCase();
            }
        }

        public String getMethod() {
            return this.method;
        }

        public boolean isRpcMode() {
            return this.isRpcMode;
        }

        public String getParameter(String name) {
            List list;
            Map map;
            Object o = this.params.get(name);
            if (o instanceof Map && (map = (Map)o).containsKey(null)) {
                o = map.get(null);
            }
            if (o instanceof List && !(list = (List)o).isEmpty()) {
                o = list.get(0);
            }
            return o instanceof String ? (String)o : null;
        }

        public Map<?, ?> getParameterMap() {
            return this.params;
        }

        public Map<?, ?> mergeParameterMap(Map<?, ?> newParams) {
            for (Map.Entry<?, ?> entry : newParams.entrySet()) {
                if (this.params.containsKey(entry.getKey())) {
                    Object target = this.params.get(entry.getKey());
                    if (target instanceof Map) {
                        Map map = (Map)target;
                        if (map.containsKey(null)) {
                            target = map.get(null);
                            if (target instanceof List) {
                                ((List)target).add(entry.getValue());
                                continue;
                            }
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(target);
                            list.add(entry.getValue());
                            map.put(null, list);
                            continue;
                        }
                        map.put(null, entry.getValue());
                        continue;
                    }
                    if (target instanceof List) {
                        ((List)target).add(entry.getValue());
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(target);
                    list.add(entry.getValue());
                    this.params.put(entry.getKey(), list);
                    continue;
                }
                this.params.put(entry.getKey(), entry.getValue());
            }
            return this.params;
        }

        public boolean hasJSONContent() {
            return this.contentLength > 0;
        }

        public String getComponentClass(String sub) {
            Matcher m = REPLACE_PATTERN.matcher(this.target);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String key = m.group(1);
                String value = this.getParameter(key);
                if (key.equals("class")) {
                    value = ClassUtil.toUpperCamel(sub != null ? sub : (value != null ? value : ""));
                } else if (value == null) {
                    value = "";
                } else if (key.equals("package")) {
                    value = value.replace('/', '.');
                }
                m.appendReplacement(sb, value);
            }
            m.appendTail(sb);
            return sb.toString();
        }

        private void parseQueryString(InputStream in, String encoding) throws IOException {
            ArrayList<Object> pairs = new ArrayList<Object>();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            int state = 0;
            ByteBuilder bb = new ByteBuilder(50);
            int before = 0;
            while (true) {
                int c;
                if ((c = in.read()) == -1) {
                    if (state == 2) {
                        bb.append((byte)before);
                    }
                    if (pairs.size() % 2 == 1) {
                        pairs.add(bb.toString(encoding));
                        break;
                    }
                    pairs.add(bb.toString(encoding));
                    pairs.add("");
                    break;
                }
                if (c == 38) {
                    if (state == 2) {
                        bb.append((byte)before);
                    }
                    if (pairs.size() % 2 == 1) {
                        pairs.add(bb.toString(encoding));
                    } else {
                        pairs.add(bb.toString(encoding));
                        pairs.add("");
                    }
                    bb.setLength(0);
                    state = 0;
                } else if (c == 61) {
                    if (state == 2) {
                        bb.append((byte)before);
                    }
                    if (pairs.size() % 2 == 1) {
                        bb.append((byte)c);
                    } else {
                        pairs.add(bb.toString(encoding));
                        bb.setLength(0);
                    }
                    state = 0;
                } else if (state == 2) {
                    int d1 = Character.digit(before, 16);
                    int d2 = Character.digit(c, 16);
                    if (d1 != -1 && d2 != -1) {
                        bb.append((byte)(d1 << 4 | d2));
                    } else {
                        bb.append((byte)before);
                        bb.append((byte)c);
                    }
                    state = 0;
                } else if (state == 1) {
                    state = 2;
                } else if (c == 43) {
                    bb.append((byte)32);
                    state = 0;
                } else if (c == 37) {
                    state = 1;
                } else {
                    bb.append((byte)c);
                    state = 0;
                }
                before = c;
            }
            Route.parseParameter(pairs, this.params);
        }

        private static void parseParameter(List<Object> pairs, Map<Object, Object> params) {
            for (int i = 0; i < pairs.size(); i += 2) {
                String name = (String)pairs.get(i);
                Object value = pairs.get(i + 1);
                int start = 0;
                int old = 0;
                LinkedHashMap<Object, Object> current = params;
                for (int j = 0; j < name.length(); ++j) {
                    char c = name.charAt(j);
                    if (c == '.' || c == '[') {
                        String key = name.substring(start, old == 93 ? j - 1 : j);
                        Object target = current.get(key);
                        if (target instanceof Map) {
                            current = (LinkedHashMap<Object, Object>)target;
                        } else {
                            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                            if (target != null) {
                                map.put(null, target);
                            }
                            current.put(key, map);
                            current = map;
                        }
                        start = j + 1;
                    }
                    old = c;
                }
                if (current.containsKey(name = name.substring(start, old == 93 ? name.length() - 1 : name.length()))) {
                    Object target = current.get(name);
                    if (target instanceof Map) {
                        Map map = (Map)target;
                        if (map.containsKey(null)) {
                            target = map.get(null);
                            if (target instanceof List) {
                                ((List)target).add(value);
                                continue;
                            }
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(target);
                            list.add(value);
                            map.put(null, list);
                            continue;
                        }
                        map.put(null, value);
                        continue;
                    }
                    if (target instanceof List) {
                        ((List)target).add(value);
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(target);
                    list.add(value);
                    current.put(name, list);
                    continue;
                }
                current.put(name, value);
            }
        }

        private static Map<String, String> parseHeaderLine(String line) {
            if (line == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int state = 0;
            StringBuilder sb = new StringBuilder(line.length());
            String key = null;
            boolean escape = false;
            block6: for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (state == 8) {
                    if (escape) {
                        if (c >= '\u0080') break;
                        sb.append(c);
                        escape = false;
                        continue;
                    }
                    if (c == '\\') {
                        escape = true;
                        continue;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                switch (c) {
                    case '\t': 
                    case ' ': {
                        if (state == 1 || state == 4) {
                            ++state;
                            continue block6;
                        }
                        if (state != 7) continue block6;
                        state = 2;
                        continue block6;
                    }
                    case ';': {
                        if (state != 1 && state != 2 && state != 7) break block6;
                        map.put(key, sb.toString());
                        sb.setLength(0);
                        state = 3;
                        continue block6;
                    }
                    case '=': {
                        if (state != 4 && state != 5) break block6;
                        key = sb.toString().toLowerCase();
                        sb.setLength(0);
                        state = 6;
                        continue block6;
                    }
                    case '\"': {
                        if (state != 6) break block6;
                        state = 8;
                        continue block6;
                    }
                    default: {
                        if (state == 0 || state == 3 || state == 6) {
                            ++state;
                        }
                        if (state != 1 && state != 4 && state != 7 || !(c >= '0' && c >= '9' || c >= 'A' && c >= 'Z' || c >= 'a' && c >= 'z' || "!#$%&'*+-.^_`|~".indexOf(c) != -1) && (state != 1 || c != '/')) break block6;
                        sb.append(c);
                    }
                }
            }
            if (state <= 2 || state == 7) {
                map.put(key, sb.toString());
            }
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteMapping {
        private static final Pattern PLACE_PATTERN = Pattern.compile("\\{\\s*(\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}\\.-]*)\\s*(?::\\s*((?:[^{}]|\\{[^{}]*\\})*)\\s*)?\\}");
        private static final Pattern DEFAULT_PATTERN = Pattern.compile("[^/().]+");
        private Pattern pattern;
        private List<String> names = new ArrayList<String>();
        private String target;

        public RouteMapping(String path, String target, Map<String, Pattern> definitions) {
            StringBuffer sb = new StringBuffer("^\\Q");
            Matcher m = PLACE_PATTERN.matcher(path);
            while (m.find()) {
                String name = m.group(1);
                this.names.add(name);
                Pattern p = DEFAULT_PATTERN;
                if (m.group(2) != null) {
                    p = Pattern.compile(m.group(2));
                } else if (definitions.containsKey(name)) {
                    p = definitions.get(name);
                }
                m.appendReplacement(sb, "\\\\E(" + p.pattern().replaceAll("\\((?!\\?)", "(?:").replace("\\", "\\\\") + ")\\\\Q");
            }
            m.appendTail(sb);
            sb.append("\\E$");
            this.pattern = Pattern.compile(sb.toString());
            this.target = target;
        }

        public Route matches(HttpServletRequest request, String path) throws IOException {
            Matcher m = this.pattern.matcher(path);
            if (m.matches()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                for (int i = 0; i < this.names.size(); ++i) {
                    String key = this.names.get(i);
                    String value = m.group(i + 1);
                    if (params.containsKey(key)) {
                        Object target = params.get(key);
                        if (target instanceof List) {
                            ((List)target).add(value);
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>(2);
                        list.add(target);
                        list.add(value);
                        continue;
                    }
                    params.put(key, value);
                }
                Route route = new Route(request, this.target, params);
                return route;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSON
    extends net.arnx.jsonic.JSON {
        @Override
        protected boolean ignore(JSON.Context context, Class<?> target, Member member) {
            return member.getDeclaringClass().equals(Throwable.class) || super.ignore(context, target, member);
        }
    }

    class RpcRequest {
        public String method;
        public List<Object> params;
        public Object id;

        RpcRequest() {
        }
    }

    protected class Config {
        public String container;
        public Class<? extends net.arnx.jsonic.JSON> processor;
        public Map<String, String> mappings;
        public Map<String, Pattern> definitions;

        protected Config() {
        }
    }
}

