package hiro.yoshioka.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class Util {

	private static Clipboard clipboard;

	public static String getHeapInfo() {
		long free = Runtime.getRuntime().freeMemory();
		long total = Runtime.getRuntime().totalMemory();
		long max = Runtime.getRuntime().maxMemory();
		long used = total - free;
		double ratio = (used * 100 / (double) total);
		return String.format("Heap info total:%s used:%s(%3.1f%%) max:%s",
				FileUtil.getLengthStringBySize(total),
				FileUtil.getLengthStringBySize(used), ratio,
				FileUtil.getLengthStringBySize(max));
	}

	protected static InputStream getStream(URL url) {
		try {
			return new BufferedInputStream(url.openStream());
		} catch (IOException e) {
			return null;
		}
	}

	public static boolean isWindowsOs() {
		String o = System.getenv().get("OS");
		if (o != null) {
			if (o.indexOf("Windows") >= 0) {
				return true;
			}
		}
		o = System.getenv().get("os.name");
		if (o != null) {
			if (o.indexOf("win") >= 0) {
				return true;
			}
		}
		return false;
	}

	public static Object copyObject(Object target) {
		ObjectOutputStream out = null;
		ObjectInputStream in = null;
		Object newObject = null;
		try {
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
			out = new ObjectOutputStream(bout);
			out.writeObject(target);
			out.flush();
			byte[] bytes = bout.toByteArray();
			in = new ObjectInputStream(new ByteArrayInputStream(bytes));
			newObject = in.readObject();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
				if (out != null) {
					out.close();
				}
			} catch (Exception ee) {
				ee.printStackTrace();
			}
		}
		return newObject;
	}

	/**
	 * @param size
	 * @return
	 */
	private static ImageData resizeImage(ImageData imageData, int size) {
		int w = size;
		int h = size;
		if (imageData.height > imageData.width) {
			double div = (double) imageData.height / size;
			w = (int) (imageData.width / div);
			if (w <= 0) {
				w = 1;
			}
		} else {
			double div = (double) imageData.width / size;
			h = (int) (imageData.height / div);
			if (h <= 0) {
				h = 1;
			}
		}
		return imageData.scaledTo(w, h);
	}

	public static Clipboard getClipboard() {
		if (clipboard == null) {
			clipboard = new Clipboard(Display.getCurrent());
		}

		return clipboard;
	}

	public static boolean matchCanNull(String str1, String str2) {
		if (str1 == null) {
			if (str2 == null) {
				return true;
			}
			return false;
		}
		return str1.equals(str2);
	}

}