package hiro.yoshioka.sdh.pair;

import hiro.yoshioka.sdh.StringRecordPairData;
import hiro.yoshioka.sdh.diff.DiffElementType;

public class DifferenceStringData extends StringRecordPairData {
	private static final long serialVersionUID = 8351692148816474906L;
	public String fDiffString;

	/**
	 * @param string
	 */
	public DifferenceStringData(DiffElementType kind) {
		fDifferenceKind = kind;
	}

	public DiffElementType fDifferenceKind = DiffElementType.NO_CHANGE;

	public StringRecordPairData createCopy() {
		DifferenceStringData ret = new DifferenceStringData(fDifferenceKind);
		ret.fParent = fParent;
		ret.fDiffString = fDiffString;
		return ret;
	}

	public void changeKind(String info, DiffElementType kind) {
		fDiffString = info;
		changeKind(kind);
	}

	/**
	 * @param no_change
	 */
	public void changeKind(DiffElementType kind) {
		fDifferenceKind = kind;
	}

	public String toString() {
		return fDifferenceKind == null ? "" : "[" + fDiffString + "]";
	}
}
