package hiro.yoshioka.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileList {
	private String _regex;
	private int depth;

	 
	public File[] getMatches(File root, int depth, String[] ignore_folders) {
		this.depth = depth;
		File[] ret = new File[0];

		if (root != null && root.exists()) {
			if (root.isFile()) {
				if (root.getName().matches(_regex)) {
					return new File[] { root };
				} else {
					return ret;
				}
			} else {
				List<File> flist = new ArrayList<File>();
				recurcse(root, flist, 1, ignore_folders);
				return flist.toArray(new File[0]);
			}
		}
		return ret;
	}

	public File[] getMatches(File root, int depth) {
		return getMatches(root, depth, StringUtil.EMPTY_STRING_ARRAY);
	}

	/**
	 * @param regex
	 */
	public FileList(String regex) {
		_regex = regex;
	}

	public void recurcse(File lib_dir, List<File> flist, int currentDepth,
			String[] ignore_folders) {
		File[] files = lib_dir.listFiles();
		if (files != null) {
			for (int j = 0; j < files.length; j++) {
				if (files[j].exists()) {
					if (files[j].isDirectory()) {
						for (String ignore : ignore_folders) {
							if (files[j].getName().equals(ignore)) {
								continue;
							}
						}
						if (depth > currentDepth || depth == -1) {
							recurcse(files[j], flist, (currentDepth + 1),
									ignore_folders);
						}
					} else if (files[j].getName().matches(_regex)) {
						flist.add(files[j]);
					}
				}
			}
		}
	}
}
