package hiro.yoshioka.sdh;

import hiro.yoshioka.util.StringUtil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SDHUtil {
	private static Log log = LogFactory.getLog(SDHUtil.class);

	static final String PRE_HTML = "<html>\r\n"
			+ "<head>\r\n"
			// + " <meta http-equiv=\"Content-Type\" content=\"text/html;
			// charset=utf-8\">\r\n"
			+ "  <LINK rel=\"stylesheet\" type=\"text/css\" href=\"%s\">\r\n"
			+ "  <script src=\"js/xpath.js\" type=\"text/javascript\"></script>\r\n"
			+ "  <script src=\"js/SpryData.js\" type=\"text/javascript\"></script>\r\n"
			+ "  <script type=\"text/javascript\">\r\n"
			+ "    var ds1 = new Spry.Data.XMLDataSet(\"%s\", \"/sdh/row\");\r\n"
			+ "  </script>\r\n" + "</head>\r\n" + "<body>\r\n" + "\r\n" +

			"<div spry:region=\"ds1\"><table   border=1>\r\n";

	static final String POST_HTML =

	" </table></div>\r\n" + " </body>\r\n" + " </html>\r\n";

	public static void main(String[] args) {
		SDHUtil obj = new SDHUtil();

		ObjectInputStream in = null;
		try {
			// in = new ObjectInputStream(new FileInputStream(
			// "D:/eclipse/rst/sample.rst"));
			in = new ObjectInputStream(new FileInputStream(
					"D:/eclipse_rcp/rst/Product.rst"));
			StringRecordDataHolder sdh = (StringRecordDataHolder) in
					.readObject();

			createHTMLWithXML(new File("a.html"), "css/gr.css", new File(
					"a.xml"), sdh, 150, 10);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				in.close();
			} catch (IOException e) {
				log.fatal(StringUtil.EMPTY_STRING, e);
			}
		}
	}

	public static boolean createHTMLWithXML(File htmlFile, String cssName,
			File xmlFile, StringRecordDataHolder sdh) {
		if (sdh2XML(xmlFile, sdh)) {
			if (sdh2HTML(htmlFile, xmlFile, cssName, sdh, -1, -1)) {
				return true;
			}
		}
		return false;
	}

	public static boolean createHTMLWithXML(File htmlFile, String cssName,
			File xmlFile, StringRecordDataHolder sdh, int samplingNum,
			int lowestLetters) {
		if (sdh2XML(xmlFile, sdh)) {
			if (sdh2HTML(htmlFile, xmlFile, cssName, sdh, samplingNum,
					lowestLetters)) {
				return true;
			}
		}
		return false;
	}

	private static String getCamelSplit(String target) {
		return target.replaceAll("([a-z])([A-Z])", "$1<BR>$2");
	}

	public static boolean sdh2HTML(File file_name, File xmlFile,
			String cssName, StringRecordDataHolder sdh, int samplingNum,
			int lowestLetters) {
		StringBuilder buf = new StringBuilder("	<thead>\r\n");

		CellParamList cl = new CellParamList(sdh, samplingNum, lowestLetters);

		for (int i = 0; i < cl.hash.size(); i++) {
			buf.append("	<tr>\r\n");
			List<CellParam> lis = cl.hash.get(i + 1);
			for (int j = 0; j < lis.size(); j++) {
				if (i == 0 && j == 0) {
					buf.append("		<th rowspan=" + cl.hash.size() + ">ROW</th>");
				} else {
					String ne = lis.get(j).getNameEsc();
					if (i == 0) {
						ne = getCamelSplit(ne);
					}
					if (lis.get(j).colSpan > 1) {
						buf.append("		<th colspan=" + lis.get(j).colSpan + ">"
								+ ne + "</th>");
					} else {
						buf.append("		<th>" + ne + "</th>");
					}
				}
			}
			buf.append("\r\n	</tr>\r\n");
		}
		buf.append("	</thead>\n<tbody spry:repeat=\"ds1\">\n");

		for (int i = 0; i < cl.hash.size(); i++) {
			buf.append("<tr class=\"{ds_EvenOddRow}\">\r\n");

			List<CellParam> lis = cl.hash.get(i + 1);
			for (int j = 0; j < lis.size(); j++) {
				if (i == 0 && j == 0) {
					buf.append("<td align=center rowspan=" + cl.hash.size()
							+ ">{ds_RowNumberPlus1}</td>\r\n");
				} else {
					if (lis.get(j).colSpan > 1) {
						buf.append("<td colspan=" + lis.get(j).colSpan
								+ ">{ds1::");
					} else {
						buf.append("<td>{ds1::");
					}
					buf.append(lis.get(j).getNameEsc());
					buf.append("}</td>\r\n");
				}
			}
			buf.append("	</tr>\r\n");
		}
		buf.append("	</tbody>\n");

		PrintWriter out = null;
		try {
			out = new PrintWriter(new BufferedWriter(new FileWriter(file_name)));

			out.println(String.format(PRE_HTML, cssName, xmlFile.getName()));
			out.println(buf.toString());
			out.println(POST_HTML);
			return true;
		} catch (Exception e) {
			log.fatal(StringUtil.EMPTY_STRING, e);
			return false;
		} finally {
			if (out != null) {
				out.flush();
				out.close();
			}
		}
	}

	public static boolean sdh2XML(File file_name, StringRecordDataHolder sdh) {
		PrintWriter out = null;
		try {
			out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(
					file_name), "UTF-8"));

			out.println("<?xml version=\"1.0\"?>");
			out.println("");
			out.println("<sdh>");
			String[] keys = sdh.getKey();
			for (int i = 0; i < sdh.getRowCount(); i++) {
				out.println("\t<row>");
				for (int j = 0; j < keys.length; j++) {
					if (StringUtil.esc(sdh.getRow(i)[j]).trim().length() == 0) {
						out.println("\t\t<" + StringUtil.escName(keys[j])
								+ "> </" + StringUtil.escName(keys[j]) + ">");
					} else {
						out.println("\t\t<" + StringUtil.escName(keys[j]) + ">"
								+ StringUtil.esc(sdh.getRow(i)[j]) + "</"
								+ StringUtil.escName(keys[j]) + ">");
					}
				}
				out.println("\t</row>");
			}
			out.println("</sdh>");
			return true;
		} catch (Exception e) {
			log.fatal(StringUtil.EMPTY_STRING, e);
			return false;
		} finally {
			if (out != null) {
				out.flush();
				out.close();
			}
		}

	}

	// -----------------------------------------------------------------

}
