/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public final class Color
extends Resource {
    public double[] handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int red, int green, int blue) {
        super(device);
        this.init(red, green, blue);
        this.init();
    }

    public Color(Device device, RGB rgb) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue);
        this.init();
    }

    void destroy() {
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        double[] rgbColor = color.handle;
        if (this.handle == rgbColor) {
            return true;
        }
        return this.device == color.device && (int)(this.handle[0] * 255.0) == (int)(rgbColor[0] * 255.0) && (int)(this.handle[1] * 255.0) == (int)(rgbColor[1] * 255.0) && (int)(this.handle[2] * 255.0) == (int)(rgbColor[2] * 255.0);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[2] * 255.0);
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[1] * 255.0);
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[0] * 255.0);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return (int)(this.handle[0] * 255.0) ^ (int)(this.handle[1] * 255.0) ^ (int)(this.handle[2] * 255.0);
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public static Color cocoa_new(Device device, double[] rgbColor) {
        Color color = new Color(device);
        color.handle = rgbColor;
        return color;
    }

    void init(int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        double[] rgbColor = new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0};
        this.handle = rgbColor;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

