package hiro.yoshioka.ui.multispan;

import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;

import javax.swing.JRootPane;
import javax.swing.JScrollPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JFaceSwingBothViewer {
	protected transient Log fLogger = LogFactory.getLog(getClass());
	ResultSetDataHolder fResultSetDataHolder;

	private RDHTableViewer fDragViewer;

	Composite fEmbededComposite;

	private SimaTable fSimaTable;

	JScrollPane sp;

	java.awt.Container fContentPane;

	private final boolean fSwingMode;

	boolean waslastAdustHeader;

	boolean supportDiff;

	public JFaceSwingBothViewer(Composite parent, boolean mode,
			boolean isVirtual, boolean supportDiff) {
		fSwingMode = mode;
		this.supportDiff = supportDiff;
		createPartControl(parent, isVirtual);
	}

	public void deleteSelectedRows() {
		if (!fSwingMode) {
			fDragViewer.deleteSelectedRows();
		} else {
			fSimaTable.deleteRows(fSimaTable.getSelectedRows());
		}
	}

	public void createPartControl(Composite parent, boolean isVirtual) {
		if (!fSwingMode) {
			fDragViewer = createRDHTableViewer(parent, isVirtual);
			fDragViewer.setSupportDiff(supportDiff);
		} else {
			fEmbededComposite = new Composite(parent, SWT.EMBEDDED);
			// try {
			// System.setProperty("sun.awt.noerasebackground", "true");
			// } catch (NoSuchMethodError error) {
			// }
			Frame frame = SWT_AWT.new_Frame(fEmbededComposite);
			frame.setLayout(new BorderLayout());
			// Panel panel = new Panel(new BorderLayout()) {
			// public void update(java.awt.Graphics g) {
			// /* Do not erase the background */
			// paint(g);
			// }
			// };
			// frame.add(panel);
			JRootPane root = new JRootPane();
			// panel.add(root);
			frame.add(root);
			fContentPane = root.getContentPane();

			replaceFrame();
		}
	}

	protected RDHTableViewer createRDHTableViewer(Composite parent,
			boolean isVirtual) {
		if (isVirtual) {
			fDragViewer = new RDHTableViewer(parent, SWT.BORDER | SWT.MULTI
					| SWT.FULL_SELECTION | SWT.HIDE_SELECTION | SWT.H_SCROLL
					| SWT.V_SCROLL | SWT.VIRTUAL);
		} else {
			fDragViewer = new RDHTableViewer(parent);
		}
		return fDragViewer;
	}

	public void setInput(ResultSetDataHolder o, boolean isAdjustHeader) {
		fResultSetDataHolder = o;
		if (isAdjustHeader) {
			adjustHeader();
		} else {
			adjustDatum();
		}
	}

	public CSVRecordDataHolder getCDH() {
		return fResultSetDataHolder;
	}

	public ResultSetDataHolder getRDH() {
		return fResultSetDataHolder;
	}

	public void cancelEditing() {
		fLogger.info("cancel");
		try {
			if (!fSwingMode) {
				fDragViewer.applyEditorValue();
			} else {
				fSimaTable.getCellEditor().stopCellEditing();
			}
		} catch (RuntimeException e) {
			fLogger.error(e);
		}
	}

	public void setFocus() {
		if (!fSwingMode) {
			try {
				fDragViewer.getControl().setFocus();
			} catch (RuntimeException e) {
				fLogger.error(e);
			}
		} else {
			fEmbededComposite.setFocus();
		}
	}

	public Composite getDisposableComponent() {
		if (!fSwingMode) {
			return fDragViewer.getTable();
		} else {
			return fEmbededComposite;
		}
	}

	public void copy() {
		if (!fSwingMode) {
			fDragViewer.doOperation(RDHTableViewer.COPY);
		} else {
			fSimaTable.getAdapter().copy();
			// if (waslastAdustHeader) {
			// adjustHeader();
			// } else {
			// adjustDatum();
			// }
		}
	}

	public void copyWithHeader() {
		if (!fSwingMode) {
			fDragViewer.doOperation(RDHTableViewer.COPY_WITH_HEAD);
		} else {
			fSimaTable.getAdapter().copyWithHeaer();
			// if (waslastAdustHeader) {
			// adjustHeader();
			// } else {
			// adjustDatum();
			// }
		}
	}

	public void pasteTo1Cell() {
		if (!fSwingMode) {
			fDragViewer.doOperation(RDHTableViewer.PASTE_IN_A_CELL);
		} else {
			fSimaTable.getAdapter().paseteTo1Cell();
			if (waslastAdustHeader) {
				adjustHeader();
			} else {
				adjustDatum();
			}
		}
	}

	public void paste() {

		if (!fSwingMode) {
			fDragViewer.doOperation(RDHTableViewer.PASTE);
		} else {
			// ResultSetDataHolder rdh = (ResultSetDataHolder)
			// Util.getClipboard()
			// .getContents(ResultSetDataHolderTransfer.getInstance());
			// System.out.println("SimapureViewer#paste:rdh:" + rdh);
			// if (rdh != null) {
			// boolean result = fResultSetDataHolder.pasteOverrideAt(
			// fSimaTable.getSelectedRow(), rdh);
			// } else {
			// String str = (String) Util.getClipboard().getContents(
			// TextTransfer.getInstance());
			// System.out.println("SimapureViewer#paste:str:" + str);
			// if (str != null && fSimaTable.getSelectedRow() >= 0
			// && fSimaTable.getSelectedColumn() >= 0) {
			//
			// String[][] datum = CSVUtil.splitCSV(str, "\t");
			// fResultSetDataHolder.pasteOverrideAt(fSimaTable
			// .getSelectedRow(), fSimaTable.getSelectedColumn(),
			// datum);
			//
			// }
			// }
			fSimaTable.getAdapter().paste();
			if (waslastAdustHeader) {
				adjustHeader();
			} else {
				adjustDatum();
			}
		}
	}

	public void adjustDatum() {
		if (!fSwingMode) {
			fDragViewer.setInputAdjustDatum(fResultSetDataHolder);
		} else {
			replaceFrame();
			fSimaTable.adjustDataWidth();
			Point p = fEmbededComposite.getSize();
			fEmbededComposite.setSize(p.x - 1, p.y);
			fEmbededComposite.setSize(p.x, p.y);
			fEmbededComposite.setVisible(true);
		}
		waslastAdustHeader = false;
	}

	public void adjustHeader() {
		if (!fSwingMode) {
			try {
				fDragViewer.setInputAdjustHeader(fResultSetDataHolder);
			} catch (RuntimeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			replaceFrame();
			fSimaTable.adjustHeaderWidth();
			Point p = fEmbededComposite.getSize();
			fEmbededComposite.setSize(p.x - 1, p.y);
			fEmbededComposite.setSize(p.x, p.y);
			fEmbededComposite.setVisible(true);
		}
		waslastAdustHeader = true;
	}

	public void adjustArea() {
		if (!fSwingMode) {
			try {
				fDragViewer.setInputAdjustArea(fResultSetDataHolder);
			} catch (RuntimeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			replaceFrame();
			fSimaTable.adjustHeaderWidth();
			Point p = fEmbededComposite.getSize();
			fEmbededComposite.setSize(p.x - 1, p.y);
			fEmbededComposite.setSize(p.x, p.y);
			fEmbededComposite.setVisible(true);
		}
		waslastAdustHeader = true;
	}

	private void replaceFrame() {
		fEmbededComposite.setVisible(false);
		fContentPane.removeAll();
		if (fResultSetDataHolder == null) {
			fSimaTable = new SimaTable();
		} else {
			ResultSetTableModel model = new ResultSetTableModel(
					fResultSetDataHolder);
			fSimaTable = new SimaTable(model);
		}
		fSimaTable.setSupportDiff(supportDiff);
		sp = new JScrollPane(fSimaTable,
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		fContentPane.add(sp);
	}

	public Control getControl() {
		if (!fSwingMode) {
			return fDragViewer.getControl();
		} else {
			return fEmbededComposite;
		}
	}

	public int[] getSelectionIndices() {
		if (!fSwingMode) {
			return fDragViewer.getTable().getSelectionIndices();
		} else {
			return fSimaTable.getSelectedRows();
		}
	}

	public void selectAll() {
		if (!fSwingMode) {
			fDragViewer.doOperation(RDHTableViewer.SELECT_ALL);
		} else {
			fSimaTable.selectAll();
		}
	}

}
