/*
 * 쐬: 2004/12/31
 */
package hiro.yoshioka.image;

import hiro.yoshioka.extract.ImageArchiveManager;
import hiro.yoshioka.extract.ArchiveManager.EntryInfo;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;

import javax.imageio.ImageIO;

/**
 * @author jomora
 */
public class ThumbnailFactory {

	private ThumbnailFactory() {
	}

	/**
	 * TlC摜쐬B 摜̃AXyNgێ܂܁Aw肵TCYɎ߂B
	 * 摜T|[gĂ摜tH[}bgłȂꍇɂ́A ÔŒӂKvB
	 * OisSupportedImageFormat()Ń`FbNĂB
	 * 
	 * @param inStrm
	 *            ̉摜
	 * @param outStrm
	 *            TlC摜
	 * @param maxThumbWidth
	 *            TlC摜̍ő啝
	 * @param maxThumbHeight
	 *            TlC摜̍ő卂
	 * @throws IOException
	 *             摜̎擾␶ɎsꍇɔB
	 */
	public static void createThumbnail(InputStream inStrm,
			OutputStream outStrm, int maxThumbWidth, int maxThumbHeight)
			throws IOException {
		// 摜
		BufferedImage image = ImageIO.read(inStrm);
		if (image == null) {
			throw new IOException("Can't read the original image.");
		}

		// 摜̕
		int width = image.getWidth();
		// 摜̍
		int height = image.getHeight();

		// ̏k{
		double widthRate = (double) maxThumbWidth / width;
		// ̏k{
		double heightRate = (double) maxThumbHeight / height;

		// TlC̏k{ij
		double rate = 1;

		// ÂA̔{Lɂ
		if (widthRate > heightRate) {
			rate = heightRate;
		} else {
			rate = widthRate;
		}
		// g͂Ȃ
		if (rate > 1) {
			rate = 1;
		}

		BufferedImage shrinkImage = new BufferedImage(
				(int) (image.getWidth() * rate),
				(int) (image.getHeight() * rate), image.getType());
		AffineTransformOp atOp = new AffineTransformOp(AffineTransform
				.getScaleInstance(rate, rate), null);

		atOp.filter(image, shrinkImage);
		ImageIO.write(shrinkImage, "jpg", outStrm);
	}

	/**
	 * ǂݍ݃T|[gĂ摜tH[}bgǂ`FbN܂B T|[gĂꍇtrue, łȂꍇfalseԂ܂B
	 * 
	 * @param extension
	 *            摜t@C̊gqiGjpg, JPEG, pNgȂǁj
	 * @return T|[gĂꍇtrue, łȂꍇfalse.
	 */
	public static boolean isSupportedReaderFormat(String extension) {
		String[] readerNames = ImageIO.getReaderFormatNames();
		for (int i = 0; i < readerNames.length; i++) {
			System.out.println(readerNames[i]);
			if (readerNames[i].equalsIgnoreCase(extension)) {
				return true;
			}
		}
		return false;
	}

	public static void main(String[] args) {
		int maxWidth = 35;
		int maxHeight = 35;

		isSupportedReaderFormat("");

		// 摜
		ImageArchiveManager obj = new ImageArchiveManager();
		EntryInfo ei = null;
		try {
			ei = obj.lookupEntrys(new File("C:/tmp/aa.zip"));
		} catch (FileNotFoundException e1) {
			// TODO ꂽ catch ubN
			e1.printStackTrace();
		} catch (IOException e1) {
			// TODO ꂽ catch ubN
			e1.printStackTrace();
		}
		ZipEntry[] zs = ei.getZipEntries();
		for (int i = 0; i < zs.length; i++) {
			System.out.println("  " + zs[i].getName() + "/"
					+ zs[i].getCompressedSize() + "/" + zs[i].getSize());
			InputStream fiStrm = null;
			FileOutputStream foStrm = null;
			try {
				fiStrm = ei.getInputStream(zs[i]);
				foStrm = new FileOutputStream(new File(
						"C:/tmp/resources/thumbnail", ei
								.getWithOutExtentionName(zs[i])
								+ ".jpg"));

				ThumbnailFactory.createThumbnail(fiStrm, foStrm, maxWidth,
						maxHeight);

			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				if (fiStrm != null) {
					try {
						fiStrm.close();
					} catch (Exception e) {
						// Do Nothing
					}
				}
				if (foStrm != null) {
					try {
						foStrm.close();
					} catch (Exception e) {
						// Do Nothing
					}
				}
			}
		}
		ei.dispose();
	}

}
