package hiro.yoshioka.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LLLFormatter extends Formatter {

	public synchronized String format(LogRecord record) {
		StringBuilder sb = new StringBuilder();
		sb.append(String.format("%tT.%<tL ", record.getMillis()));
		if (record.getSourceClassName() != null) {
			sb.append(record.getSourceClassName());
		} else {
			sb.append(record.getLoggerName());
		}
		if (record.getSourceMethodName() != null) {
			sb.append("#");
			sb.append(record.getSourceMethodName());
		}
		// sb.append(lineSeparator);
		String message = formatMessage(record);
		sb.append(String.format("[%s] %s%n", record.getLevel()
				.getLocalizedName(), message));
		if (record.getThrown() != null) {
			try {
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
				record.getThrown().printStackTrace(pw);
				pw.close();
				sb.append(sw.toString());
			} catch (Exception ex) {
			}
		}
		return sb.toString();
	}
}
