/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.collect.StandardTable;
import com.google.appengine.repackaged.com.google.common.collect.Table;
import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public class HashBasedTable<R, C, V>
extends StandardTable<R, C, V> {
    private static final long serialVersionUID = 0L;

    private static <C, V> Map<C, V> newHashMapWithExpectedSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0);
        return new HashMap(Math.max(expectedSize * 2, 16));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create() {
        return new HashBasedTable(new HashMap(), new Factory(0));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create(int rows, int columnsPerRow) {
        Preconditions.checkArgument(columnsPerRow >= 0);
        Map<C, V> backingMap = HashBasedTable.newHashMapWithExpectedSize(rows);
        return new HashBasedTable(backingMap, new Factory(columnsPerRow));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create(Table<? extends R, ? extends C, ? extends V> table) {
        HashBasedTable<? extends R, ? extends C, ? extends V> result = HashBasedTable.create();
        result.putAll(table);
        return result;
    }

    private HashBasedTable(Map<R, Map<C, V>> backingMap, Factory<C, V> factory) {
        super(backingMap, factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory<C, V>
    implements Supplier<Map<C, V>>,
    Serializable {
        final int expectedSize;
        private static final long serialVersionUID = 0L;

        Factory(int expectedSize) {
            this.expectedSize = expectedSize;
        }

        @Override
        public Map<C, V> get() {
            return HashBasedTable.newHashMapWithExpectedSize(this.expectedSize);
        }
    }
}

