/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTypeTranslator {
    private static final Map<Class<?>, Type<?>> typeMap = new HashMap();
    private static final Map<Class<? extends Comparable>, Integer> comparableTypeMap;
    private static final AsComparableFunction NOT_COMPARABLE;
    private static final AsComparableFunction COMP_BYTE_ARRAY_FUNC;
    private static final AsComparableFunction INT_64_COMP_FUNC;
    private static final AsComparableFunction DOUBLE_COMP_FUNC;
    private static final AsComparableFunction BOOLEAN_COMP_FUNC;

    public static void addPropertiesToPb(Map<String, Object> map, OnestoreEntity.EntityProto proto) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                for (Object listValue : values) {
                    Pair<Type<?>, OnestoreEntity.Property> results = DataTypeTranslator.createProperty(key, listValue, true);
                    DataTypeTranslator.addProperty(proto, results.second(), results.first());
                }
                continue;
            }
            Pair<Type<?>, OnestoreEntity.Property> results = DataTypeTranslator.createProperty(key, value, false);
            DataTypeTranslator.addProperty(proto, results.second(), results.first());
        }
    }

    private static void addProperty(OnestoreEntity.EntityProto entity, OnestoreEntity.Property property, Type<?> type) {
        if (type == null || type.getComparableFunction() != null) {
            entity.addProperty(property);
        } else {
            entity.addRawProperty(property);
        }
    }

    private static Pair<Type<?>, OnestoreEntity.Property> createProperty(String name, Object value, boolean multiple) {
        OnestoreEntity.Property property = new OnestoreEntity.Property();
        property.setName(name);
        property.setMultiple(multiple);
        OnestoreEntity.PropertyValue newValue = new OnestoreEntity.PropertyValue();
        if (value == null) {
            return Pair.of(null, property);
        }
        Type<?> type = DataTypeTranslator.getType(value.getClass());
        OnestoreEntity.Property.Meaning meaning = type.getMeaning();
        if (meaning != null) {
            property.setMeaning(meaning);
        }
        type.setPropertyValue(newValue, value);
        property.setValue(newValue);
        return new Pair(type, property);
    }

    public static void extractIndexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.propertys()) {
            DataTypeTranslator.addPropertyValueToMap(property, map);
        }
    }

    public static void extractPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        DataTypeTranslator.extractIndexedPropertiesFromPb(proto, map);
        for (OnestoreEntity.Property property : proto.rawPropertys()) {
            DataTypeTranslator.addPropertyValueToMap(property, map);
        }
    }

    public static void extractImplicitPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : DataTypeTranslator.getImplicitProperties(proto)) {
            DataTypeTranslator.addPropertyValueToMap(property, map);
        }
    }

    private static Iterable<OnestoreEntity.Property> getImplicitProperties(OnestoreEntity.EntityProto proto) {
        return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
    }

    private static OnestoreEntity.Property buildImplicitKeyProperty(OnestoreEntity.EntityProto proto) {
        OnestoreEntity.Property keyProp = new OnestoreEntity.Property();
        keyProp.setName("__key__");
        OnestoreEntity.PropertyValue propVal = new OnestoreEntity.PropertyValue();
        ReferenceType.setPropertyValue(propVal, proto.getKey());
        keyProp.setValue(propVal);
        return keyProp;
    }

    public static Collection<OnestoreEntity.Property> findIndexedPropertiesOnPb(OnestoreEntity.EntityProto proto, String propertyName) {
        if (propertyName.equals("__key__")) {
            return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
        }
        ArrayList<OnestoreEntity.Property> multipleProps = new ArrayList<OnestoreEntity.Property>();
        OnestoreEntity.Property singleProp = DataTypeTranslator.addPropertiesWithName(proto.propertys(), propertyName, multipleProps);
        if (singleProp != null) {
            return Collections.singleton(singleProp);
        }
        return multipleProps;
    }

    private static OnestoreEntity.Property addPropertiesWithName(Iterable<OnestoreEntity.Property> props, String propName, Collection<OnestoreEntity.Property> matchingMultipleProps) {
        for (OnestoreEntity.Property prop : props) {
            if (!prop.getName().equals(propName)) continue;
            if (!prop.isMultiple()) {
                return prop;
            }
            matchingMultipleProps.add(prop);
        }
        return null;
    }

    private static void addPropertyValueToMap(OnestoreEntity.Property property, Map<String, Object> map) {
        String name = property.getName();
        Object value = DataTypeTranslator.getPropertyValue(property);
        if (property.isMultiple()) {
            ArrayList<Object> results = (ArrayList<Object>)map.get(name);
            if (results == null) {
                results = new ArrayList<Object>();
                map.put(name, results);
            }
            results.add(value);
        } else {
            map.put(name, value);
        }
    }

    public static Object getPropertyValue(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        for (Type<?> type : typeMap.values()) {
            if (!type.hasPropertyValue(value) || type.getMeaning() != property.getMeaningEnum()) continue;
            return type.getPropertyValue(value);
        }
        return null;
    }

    public static Comparable<Object> getComparablePropertyValue(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        for (Type<?> type : typeMap.values()) {
            if (!type.hasPropertyValue(value) || type.getMeaning() != property.getMeaningEnum() || type.getComparableFunction() == null) continue;
            return type.getComparableFunction().asComparable(value);
        }
        return null;
    }

    public static int getTypeRank(Class<? extends Comparable> datastoreType) {
        return comparableTypeMap.get(datastoreType);
    }

    static OnestoreEntity.Property toProperty(String propertyName, Object value) {
        return DataTypeTranslator.createProperty(propertyName, value, false).second();
    }

    private static <T> Type<T> getType(Class<T> clazz) {
        if (typeMap.containsKey(clazz)) {
            return typeMap.get(clazz);
        }
        throw new UnsupportedOperationException("Unsupported data type: " + clazz.getName());
    }

    static Map<Class<?>, Type<?>> getTypeMap() {
        return typeMap;
    }

    private DataTypeTranslator() {
    }

    static {
        typeMap.put(String.class, new StringType());
        typeMap.put(Byte.class, new Int64Type());
        typeMap.put(Short.class, new Int64Type());
        typeMap.put(Integer.class, new Int64Type());
        typeMap.put(Long.class, new Int64Type());
        typeMap.put(Float.class, new DoubleType());
        typeMap.put(Double.class, new DoubleType());
        typeMap.put(Boolean.class, new BoolType());
        typeMap.put(User.class, new UserType());
        typeMap.put(Key.class, new ReferenceType());
        typeMap.put(Blob.class, new BlobType());
        typeMap.put(Text.class, new TextType());
        typeMap.put(Date.class, new DateType());
        typeMap.put(Link.class, new LinkType());
        typeMap.put(ShortBlob.class, new ShortBlobType());
        assert (((Object)typeMap.keySet()).equals(DataTypeUtils.getSupportedTypes())) : "Warning:  DataTypeUtils and DataTypeTranslator do not agree about supported classes: " + typeMap.keySet() + " vs. " + DataTypeUtils.getSupportedTypes();
        comparableTypeMap = new HashMap<Class<? extends Comparable>, Integer>();
        comparableTypeMap.put(ComparableByteArray.class, 3);
        comparableTypeMap.put(Long.class, 1);
        comparableTypeMap.put(Double.class, 4);
        comparableTypeMap.put(Boolean.class, 2);
        comparableTypeMap.put(User.class, 8);
        comparableTypeMap.put(Key.class, 12);
        NOT_COMPARABLE = null;
        COMP_BYTE_ARRAY_FUNC = new AsComparableFunction(){

            public Comparable asComparable(OnestoreEntity.PropertyValue pv) {
                return new ComparableByteArray(pv.getStringValueAsBytes());
            }
        };
        INT_64_COMP_FUNC = new AsComparableFunction(){

            public Comparable asComparable(OnestoreEntity.PropertyValue pv) {
                return Long.valueOf(pv.getInt64Value());
            }
        };
        DOUBLE_COMP_FUNC = new AsComparableFunction(){

            public Comparable asComparable(OnestoreEntity.PropertyValue pv) {
                return Double.valueOf(pv.getDoubleValue());
            }
        };
        BOOLEAN_COMP_FUNC = new AsComparableFunction(){

            public Comparable asComparable(OnestoreEntity.PropertyValue pv) {
                return Boolean.valueOf(pv.isBooleanValue());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        private final byte[] bytes;

        public ComparableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int compareTo(ComparableByteArray other) {
            byte[] otherBytes = other.bytes;
            for (int i = 0; i < Math.min(this.bytes.length, otherBytes.length); ++i) {
                int v1 = this.bytes[i] & 0xFF;
                int v2 = otherBytes[i] & 0xFF;
                if (v1 == v2) continue;
                return v1 - v2;
            }
            return this.bytes.length - otherBytes.length;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.bytes, ((ComparableByteArray)obj).bytes);
        }

        public int hashCode() {
            int result = 1;
            for (byte b : this.bytes) {
                result = 31 * result + b;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<T, U> {
        private final T first;
        private final U second;

        Pair(T t, U u) {
            this.first = t;
            this.second = u;
        }

        T first() {
            return this.first;
        }

        U second() {
            return this.second;
        }

        public static <T, U> Pair<T, U> of(T t, U u) {
            return new Pair<T, U>(t, u);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortBlobType
    extends Type<ShortBlob> {
        public ShortBlobType() {
            super(OnestoreEntity.Property.Meaning.BYTESTRING);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            propertyValue.setStringValueAsBytes(((ShortBlob)value).getBytes());
        }

        @Override
        public ShortBlob getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new ShortBlob(propertyValue.getStringValueAsBytes());
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_BYTE_ARRAY_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkType
    extends Type<Link> {
        public LinkType() {
            super(OnestoreEntity.Property.Meaning.ATOM_LINK);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Link link = (Link)value;
            propertyValue.setStringValue(link.getValue());
        }

        @Override
        public Link getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new Link(propertyValue.getStringValue());
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_BYTE_ARRAY_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateType
    extends Type<Date> {
        public DateType() {
            super(OnestoreEntity.Property.Meaning.GD_WHEN);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Date date = (Date)value;
            propertyValue.setInt64Value(date.getTime() * 1000L);
        }

        @Override
        public Date getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new Date(propertyValue.getInt64Value() / 1000L);
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return INT_64_COMP_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasInt64Value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextType
    extends Type<Text> {
        public TextType() {
            super(OnestoreEntity.Property.Meaning.TEXT);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Text text = (Text)value;
            propertyValue.setStringValue(text.getValue());
        }

        @Override
        public Text getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new Text(propertyValue.getStringValue());
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return NOT_COMPARABLE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlobType
    extends Type<Blob> {
        public BlobType() {
            super(OnestoreEntity.Property.Meaning.BLOB);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Blob blob = (Blob)value;
            propertyValue.setStringValueAsBytes(blob.getBytes());
        }

        @Override
        public Blob getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            byte[] bytes = propertyValue.getStringValueAsBytes();
            return new Blob(bytes);
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return NOT_COMPARABLE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceType
    extends Type<Key> {
        private final AsComparableFunction COMP_FUNC = new AsComparableFunction(){

            public Comparable asComparable(OnestoreEntity.PropertyValue pv) {
                return ReferenceType.this.getPropertyValue(pv);
            }
        };

        private ReferenceType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            OnestoreEntity.Reference keyRef = KeyTranslator.convertToPb((Key)value);
            ReferenceType.setPropertyValue(propertyValue, keyRef);
        }

        private static void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, OnestoreEntity.Reference keyRef) {
            OnestoreEntity.PropertyValue.ReferenceValue refValue = new OnestoreEntity.PropertyValue.ReferenceValue();
            refValue.setApp(keyRef.getApp());
            OnestoreEntity.Path path = keyRef.getPath();
            for (OnestoreEntity.Path.Element element : path.elements()) {
                OnestoreEntity.PropertyValue.ReferenceValuePathElement newElement = new OnestoreEntity.PropertyValue.ReferenceValuePathElement();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                refValue.addPathElement(newElement);
            }
            propertyValue.setReferenceValue(refValue);
        }

        @Override
        public Key getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
            OnestoreEntity.PropertyValue.ReferenceValue refValue = propertyValue.getReferenceValue();
            reference.setApp(refValue.getApp());
            OnestoreEntity.Path path = new OnestoreEntity.Path();
            for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : refValue.pathElements()) {
                OnestoreEntity.Path.Element newElement = new OnestoreEntity.Path.Element();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                path.addElement(newElement);
            }
            reference.setPath(path);
            return KeyTranslator.createFromPb(reference);
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasReferenceValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return this.COMP_FUNC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserType
    extends Type<User> {
        private final AsComparableFunction USER_COMP_FUNC = new AsComparableFunction(){

            public Comparable asComparable(OnestoreEntity.PropertyValue pv) {
                return UserType.this.getPropertyValue(pv);
            }
        };

        private UserType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            User user = (User)value;
            OnestoreEntity.PropertyValue.UserValue userValue = new OnestoreEntity.PropertyValue.UserValue();
            userValue.setEmail(user.getEmail());
            userValue.setAuthDomain(user.getAuthDomain());
            userValue.setGaiaid(0L);
            propertyValue.setUserValue(userValue);
        }

        @Override
        public User getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.UserValue userValue = propertyValue.getUserValue();
            return new User(userValue.getEmail(), userValue.getAuthDomain());
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasUserValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return this.USER_COMP_FUNC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoolType
    extends Type<Boolean> {
        private BoolType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            if (value != null) {
                propertyValue.setBooleanValue((Boolean)value);
            }
        }

        @Override
        public Boolean getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.isBooleanValue();
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasBooleanValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return BOOLEAN_COMP_FUNC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleType
    extends Type<Double> {
        private DoubleType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            if (value != null) {
                propertyValue.setDoubleValue(((Number)value).doubleValue());
            }
        }

        @Override
        public Double getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasDoubleValue() ? Double.valueOf(propertyValue.getDoubleValue()) : null;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasDoubleValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return DOUBLE_COMP_FUNC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Int64Type
    extends Type<Long> {
        private Int64Type() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            if (value != null) {
                propertyValue.setInt64Value(((Number)value).longValue());
            }
        }

        @Override
        public Long getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.getInt64Value();
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasInt64Value();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return INT_64_COMP_FUNC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringType
    extends Type<String> {
        private StringType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            propertyValue.setStringValue((String)value);
        }

        @Override
        public String getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.getStringValue();
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_BYTE_ARRAY_FUNC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Type<T> {
        private final OnestoreEntity.Property.Meaning meaning;

        protected Type(OnestoreEntity.Property.Meaning meaning) {
            this.meaning = meaning;
        }

        protected Type() {
            this(null);
        }

        public abstract AsComparableFunction getComparableFunction();

        public OnestoreEntity.Property.Meaning getMeaning() {
            return this.meaning;
        }

        public abstract void setPropertyValue(OnestoreEntity.PropertyValue var1, Object var2);

        public abstract T getPropertyValue(OnestoreEntity.PropertyValue var1);

        public abstract boolean hasPropertyValue(OnestoreEntity.PropertyValue var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AsComparableFunction {
        public Comparable<?> asComparable(OnestoreEntity.PropertyValue var1);
    }
}

