/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Nullable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static <T> T nonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T nonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : Objects.nonNull(second);
    }

    public static boolean deepEquals(@Nullable Object a, @Nullable Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> type1 = a.getClass();
        Class<?> type2 = b.getClass();
        if (!type1.isArray() || !type2.isArray()) {
            return a.equals(b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.deepEquals((Object[])a, (Object[])b);
        }
        if (type1 != type2) {
            return false;
        }
        if (a instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        throw new AssertionError();
    }

    public static int deepHashCode(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!obj.getClass().isArray()) {
            return obj.hashCode();
        }
        if (obj instanceof Object[]) {
            return Arrays.deepHashCode((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.hashCode((boolean[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.hashCode((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.hashCode((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.hashCode((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.hashCode((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.hashCode((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.hashCode((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.hashCode((double[])obj);
        }
        throw new AssertionError();
    }

    public static String deepToString(@Nullable Object obj) {
        if (obj == null) {
            return String.valueOf(obj);
        }
        if (!obj.getClass().isArray()) {
            return obj.toString();
        }
        if (obj instanceof Object[]) {
            return Arrays.deepToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        throw new AssertionError();
    }
}

