/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Query;
import com.google.apphosting.api.DatastorePb;
import java.util.List;

final class QueryTranslator {
    public static DatastorePb.Query convertToPb(Query query, FetchOptions fetchOptions) {
        String appId;
        Key ancestor = query.getAncestor();
        List<Query.FilterPredicate> filterPredicates = query.getFilterPredicates();
        List<Query.SortPredicate> sortPredicates = query.getSortPredicates();
        DatastorePb.Query proto = new DatastorePb.Query();
        if (query.getKind() != null) {
            proto.setKind(query.getKind());
        }
        if ((appId = query.getAppId()) == null) {
            appId = DatastoreApiHelper.getCurrentAppId();
        }
        proto.setApp(appId);
        if (fetchOptions.hasOffset()) {
            proto.setOffset(fetchOptions.getOffset());
        }
        if (fetchOptions.hasLimit()) {
            proto.setLimit(fetchOptions.getLimit());
        }
        if (ancestor != null) {
            proto.setAncestor(KeyTranslator.convertToPb(ancestor));
        }
        for (Query.FilterPredicate filterPredicate : filterPredicates) {
            DatastorePb.Query.Filter filter = proto.addFilter();
            filter.copyFrom(QueryTranslator.convertFilterPredicateToPb(filterPredicate));
        }
        for (Query.SortPredicate sortPredicate : sortPredicates) {
            DatastorePb.Query.Order order = proto.addOrder();
            order.copyFrom(QueryTranslator.convertSortPredicateToPb(sortPredicate));
        }
        return proto;
    }

    private static DatastorePb.Query.Order convertSortPredicateToPb(Query.SortPredicate predicate) {
        DatastorePb.Query.Order order = new DatastorePb.Query.Order();
        order.setProperty(predicate.getPropertyName());
        order.setDirection(QueryTranslator.getSortOp(predicate.getDirection()));
        return order;
    }

    private static DatastorePb.Query.Order.Direction getSortOp(Query.SortDirection direction) {
        switch (direction) {
            case ASCENDING: {
                return DatastorePb.Query.Order.Direction.ASCENDING;
            }
            case DESCENDING: {
                return DatastorePb.Query.Order.Direction.DESCENDING;
            }
        }
        throw new UnsupportedOperationException("direction: " + (Object)((Object)direction));
    }

    private static DatastorePb.Query.Filter convertFilterPredicateToPb(Query.FilterPredicate predicate) {
        DatastorePb.Query.Filter filter = new DatastorePb.Query.Filter();
        filter.setOp(QueryTranslator.getFilterOp(predicate.getOperator()));
        filter.addProperty(DataTypeTranslator.toProperty(predicate.getPropertyName(), predicate.getValue()));
        return filter;
    }

    private static DatastorePb.Query.Filter.Operator getFilterOp(Query.FilterOperator operator) {
        switch (operator) {
            case LESS_THAN: {
                return DatastorePb.Query.Filter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return DatastorePb.Query.Filter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return DatastorePb.Query.Filter.Operator.EQUAL;
            }
        }
        throw new UnsupportedOperationException("operator: " + (Object)((Object)operator));
    }

    private QueryTranslator() {
    }
}

