/*
  iocs_key.c

  functions for compatibility to iocslib
  ( containing mainly key oriented functions )

  Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "../sted.h"
#include "sted_screen.h"

extern "C" {

// dummy
char KEY_XF1[128];               /* keysym names */
char KEY_XF2[128];
char KEY_XF3[128];
char KEY_XF4[128];
char KEY_XF5[128];
char KEY_KANA[128];
char KEY_KIGO[128];
char KEY_TOROKU[128];
char KEY_INS[128];
char KEY_DEL[128];
char KEY_HOME[128];
char KEY_UNDO[128];
char KEY_RUP[128];
char KEY_RDOWN[128];
char KEY_OPT1[128];
char KEY_OPT2[128];

/* key input */

void
_iocs_ledmod( int in_code, int in_onoff )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->LedMode(in_code, in_onoff);
  return;
}

int
_iocs_b_keyinp( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->KeyInp();
}

int
_iocs_b_keysns( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->KeySense();
}

int
_iocs_b_sftsns( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->SftSense();
}

int
_iocs_bitsns( int in_group )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  return scr->BitSense(in_group);
}

}
