/*
  ==============================================================================

  This is an automatically generated file created by the Jucer!

  Creation date:  3 Sep 2009 6:09:32 am

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Jucer version: 1.11

  ------------------------------------------------------------------------------

  The Jucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-6 by Raw Material Software ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...
#include "includes.h"
using namespace JUCE_NAMESPACE;
#pragma push_macro("T")
#undef T
#include "source.h"
#pragma pop_macro("T")
//[/Headers]

#include "WinAudioComponent.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
WinAudioComponent::WinAudioComponent (boost::uint32_t handle)
    : Component (T("WinAudioComponent")),
      lastActionGroup (0),
      CaputureDevicelGroup (0),
      waveFileGroup (0),
      deviceRoleGroup (0),
      playerControl (0),
      DeviceSharing (0),
      playbackMode (0),
      BufferLatency (0),
      playbackDevicelGroup (0),
      playbackVolumeGroup (0),
      playButton (0),
      stopButton (0),
      sharedMode (0),
      exclusiveMode (0),
      playbackVolume (0),
      playbackConsoleButton (0),
      playbackCommunicationsButton (0),
      playbackMultimediaButton (0),
      playbackDeviceCombo (0),
      deviceNameLabel (0),
      pushModeButton (0),
      eventModeButton (0),
      bufferLatencySlider (0),
      latencyLabel1 (0),
      latencyLabel100 (0),
      latencyLabel50 (0),
      audioSourceGroup (0),
      toneGeneratorSource (0),
      waveFileSource (0),
      captureDeviceSource (0),
      waveFileNameText (0),
      fileNameLabel (0),
      selectFileButton (0),
      repeatModeButton (0),
      deviceRoleGroup2 (0),
      caputureConsoleButton (0),
      caputureCommunicationsButton2 (0),
      caputureMultimediaButton (0),
      caputureDeviceCombo (0),
      deviceNameLabel3 (0),
      MMCSSGroup (0),
      enableMMCSSButton (0),
      criticalButton (0),
      normalButton (0),
      highButton (0),
      lowButton (0),
      lastActionLabel (0)
{
    addAndMakeVisible (lastActionGroup = new GroupComponent (T("lastActionGroup"),
                                                             T("Last Action")));

    addAndMakeVisible (CaputureDevicelGroup = new GroupComponent (T("CaputureDevicelGroup"),
                                                                  T("Caputure Device")));

    addAndMakeVisible (waveFileGroup = new GroupComponent (T("waveFileGroup"),
                                                           T("Wave File")));

    addAndMakeVisible (deviceRoleGroup = new GroupComponent (T("deviceRoleGroup"),
                                                             T("Device Role")));

    addAndMakeVisible (playerControl = new GroupComponent (T("playerControl"),
                                                           T("Player Control")));

    addAndMakeVisible (DeviceSharing = new GroupComponent (T("deviceShareing"),
                                                           T("Device Shareing")));

    addAndMakeVisible (playbackMode = new GroupComponent (T("PlaybackMode"),
                                                          T("Playback Mode")));

    addAndMakeVisible (BufferLatency = new GroupComponent (T("BufferLatency"),
                                                           T("Buffer Latency")));

    addAndMakeVisible (playbackDevicelGroup = new GroupComponent (T("PlaybackDeviceGroup"),
                                                                  T("Playback Device")));

    addAndMakeVisible (playbackVolumeGroup = new GroupComponent (T("PlaybackVolumeGroup"),
                                                                 T("Playback Volume")));

    addAndMakeVisible (playButton = new TextButton (T("Play Sound")));
    playButton->setButtonText (T("Play"));
    playButton->addButtonListener (this);

    addAndMakeVisible (stopButton = new TextButton (T("Stop Soubd")));
    stopButton->setButtonText (T("Stop"));
    stopButton->addButtonListener (this);

    addAndMakeVisible (sharedMode = new ToggleButton (T("sharedMode")));
    sharedMode->setButtonText (T("SharedMode"));
    sharedMode->setRadioGroupId (1);
    sharedMode->addButtonListener (this);
    sharedMode->setToggleState (true, false);

    addAndMakeVisible (exclusiveMode = new ToggleButton (T("ExclusiveMode")));
    exclusiveMode->setButtonText (T("Exclusive Mode"));
    exclusiveMode->setRadioGroupId (1);
    exclusiveMode->addButtonListener (this);

    addAndMakeVisible (playbackVolume = new Slider (T("PlayBackVolume")));
    playbackVolume->setRange (0, 1, 0.1);
    playbackVolume->setSliderStyle (Slider::LinearHorizontal);
    playbackVolume->setTextBoxStyle (Slider::TextBoxLeft, false, 80, 20);
    playbackVolume->addListener (this);

    addAndMakeVisible (playbackConsoleButton = new TextButton (T("PlaybackConsoleButton")));
    playbackConsoleButton->setButtonText (T("Console"));
    playbackConsoleButton->addButtonListener (this);

    addAndMakeVisible (playbackCommunicationsButton = new TextButton (T("PlaybackCommunicationsButton")));
    playbackCommunicationsButton->setButtonText (T("Communications"));
    playbackCommunicationsButton->addButtonListener (this);

    addAndMakeVisible (playbackMultimediaButton = new TextButton (T("PlaybackMultimediaButton")));
    playbackMultimediaButton->setButtonText (T("MultiMedia"));
    playbackMultimediaButton->addButtonListener (this);

    addAndMakeVisible (playbackDeviceCombo = new ComboBox (T("playbackDeviceCombo")));
    playbackDeviceCombo->setEditableText (false);
    playbackDeviceCombo->setJustificationType (Justification::centredLeft);
    playbackDeviceCombo->setTextWhenNothingSelected (String::empty);
    playbackDeviceCombo->setTextWhenNoChoicesAvailable (T("(no choices)"));
    playbackDeviceCombo->addListener (this);

    addAndMakeVisible (deviceNameLabel = new Label (T("deviceNameLabel"),
                                                    T("Device Name")));
    deviceNameLabel->setFont (Font (15.0000f, Font::plain));
    deviceNameLabel->setJustificationType (Justification::centredLeft);
    deviceNameLabel->setEditable (false, false, false);
    deviceNameLabel->setColour (TextEditor::textColourId, Colours::black);
    deviceNameLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (pushModeButton = new ToggleButton (T("pushModeButton")));
    pushModeButton->setButtonText (T("Push Mode"));
    pushModeButton->setRadioGroupId (2);
    pushModeButton->addButtonListener (this);

    addAndMakeVisible (eventModeButton = new ToggleButton (T("eventModeButton")));
    eventModeButton->setButtonText (T("Event Mode"));
    eventModeButton->setRadioGroupId (2);
    eventModeButton->addButtonListener (this);

    addAndMakeVisible (bufferLatencySlider = new Slider (T("bufferLatencySlider")));
    bufferLatencySlider->setRange (0, 10, 0);
    bufferLatencySlider->setSliderStyle (Slider::LinearHorizontal);
    bufferLatencySlider->setTextBoxStyle (Slider::NoTextBox, false, 80, 20);
    bufferLatencySlider->addListener (this);

    addAndMakeVisible (latencyLabel1 = new Label (T("latencyLabel1"),
                                                  T("1ms")));
    latencyLabel1->setFont (Font (11.8000f, Font::plain));
    latencyLabel1->setJustificationType (Justification::centredLeft);
    latencyLabel1->setEditable (false, false, false);
    latencyLabel1->setColour (TextEditor::textColourId, Colours::black);
    latencyLabel1->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (latencyLabel100 = new Label (T("latencyLabel100"),
                                                    T("100ms")));
    latencyLabel100->setFont (Font (10.1000f, Font::plain));
    latencyLabel100->setJustificationType (Justification::centredLeft);
    latencyLabel100->setEditable (false, false, false);
    latencyLabel100->setColour (TextEditor::textColourId, Colours::black);
    latencyLabel100->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (latencyLabel50 = new Label (T("latencyLabel50"),
                                                   T("50ms")));
    latencyLabel50->setFont (Font (11.2000f, Font::plain));
    latencyLabel50->setJustificationType (Justification::centredLeft);
    latencyLabel50->setEditable (false, false, false);
    latencyLabel50->setColour (TextEditor::textColourId, Colours::black);
    latencyLabel50->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (audioSourceGroup = new GroupComponent (T("audioSourceGroup"),
                                                              T("Audio Source")));

    addAndMakeVisible (toneGeneratorSource = new ToggleButton (T("toneGeneratorSource")));
    toneGeneratorSource->setButtonText (T("Tone Generator"));
    toneGeneratorSource->setRadioGroupId (3);
    toneGeneratorSource->addButtonListener (this);

    addAndMakeVisible (waveFileSource = new ToggleButton (T("waveFileSource")));
    waveFileSource->setButtonText (T("Wave File"));
    waveFileSource->setRadioGroupId (3);
    waveFileSource->addButtonListener (this);

    addAndMakeVisible (captureDeviceSource = new ToggleButton (T("captureDeviceSource")));
    captureDeviceSource->setButtonText (T("Capture Device"));
    captureDeviceSource->setRadioGroupId (3);
    captureDeviceSource->addButtonListener (this);

    addAndMakeVisible (waveFileNameText = new TextEditor (T("waveFileNameText")));
    waveFileNameText->setMultiLine (false);
    waveFileNameText->setReturnKeyStartsNewLine (false);
    waveFileNameText->setReadOnly (false);
    waveFileNameText->setScrollbarsShown (true);
    waveFileNameText->setCaretVisible (true);
    waveFileNameText->setPopupMenuEnabled (true);
    waveFileNameText->setText (String::empty);

    addAndMakeVisible (fileNameLabel = new Label (T("fileNameLabel"),
                                                  T("File Name")));
    fileNameLabel->setFont (Font (15.0000f, Font::plain));
    fileNameLabel->setJustificationType (Justification::centredLeft);
    fileNameLabel->setEditable (false, false, false);
    fileNameLabel->setColour (TextEditor::textColourId, Colours::black);
    fileNameLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (selectFileButton = new TextButton (T("selectFileButton")));
    selectFileButton->setButtonText (T("Select File"));
    selectFileButton->addButtonListener (this);

    addAndMakeVisible (repeatModeButton = new ToggleButton (T("repeatModeButton")));
    repeatModeButton->setButtonText (T("Repeat Mode"));
    repeatModeButton->addButtonListener (this);

    addAndMakeVisible (deviceRoleGroup2 = new GroupComponent (T("deviceRoleGroup"),
                                                              T("Device Role")));

    addAndMakeVisible (caputureConsoleButton = new TextButton (T("caputureConsoleButton")));
    caputureConsoleButton->setButtonText (T("Console"));
    caputureConsoleButton->addButtonListener (this);

    addAndMakeVisible (caputureCommunicationsButton2 = new TextButton (T("caputureCommunicationsButton")));
    caputureCommunicationsButton2->setButtonText (T("Communications"));
    caputureCommunicationsButton2->addButtonListener (this);

    addAndMakeVisible (caputureMultimediaButton = new TextButton (T("caputureMultimediaButton")));
    caputureMultimediaButton->setButtonText (T("MultiMedia"));
    caputureMultimediaButton->addButtonListener (this);

    addAndMakeVisible (caputureDeviceCombo = new ComboBox (T("caputureDeviceCombo")));
    caputureDeviceCombo->setEditableText (false);
    caputureDeviceCombo->setJustificationType (Justification::centredLeft);
    caputureDeviceCombo->setTextWhenNothingSelected (String::empty);
    caputureDeviceCombo->setTextWhenNoChoicesAvailable (T("(no choices)"));
    caputureDeviceCombo->addListener (this);

    addAndMakeVisible (deviceNameLabel3 = new Label (T("deviceNameLabel"),
                                                     T("Device Name")));
    deviceNameLabel3->setFont (Font (15.0000f, Font::plain));
    deviceNameLabel3->setJustificationType (Justification::centredLeft);
    deviceNameLabel3->setEditable (false, false, false);
    deviceNameLabel3->setColour (TextEditor::textColourId, Colours::black);
    deviceNameLabel3->setColour (TextEditor::backgroundColourId, Colour (0x0));

    addAndMakeVisible (MMCSSGroup = new GroupComponent (T("MMCSSGroup"),
                                                        T("Multimedia Class Scheduler Service")));

    addAndMakeVisible (enableMMCSSButton = new ToggleButton (T("enableMMCSSButton")));
    enableMMCSSButton->setButtonText (T("Enable MMCSS"));
    enableMMCSSButton->addButtonListener (this);

    addAndMakeVisible (criticalButton = new ToggleButton (T("criticalButton")));
    criticalButton->setButtonText (T("critical"));
    criticalButton->setRadioGroupId (4);
    criticalButton->addButtonListener (this);

    addAndMakeVisible (normalButton = new ToggleButton (T("normalButton")));
    normalButton->setButtonText (T("Normal"));
    normalButton->setRadioGroupId (4);
    normalButton->addButtonListener (this);

    addAndMakeVisible (highButton = new ToggleButton (T("highButton")));
    highButton->setButtonText (T("High"));
    highButton->setRadioGroupId (4);
    highButton->addButtonListener (this);

    addAndMakeVisible (lowButton = new ToggleButton (T("lowButton")));
    lowButton->setButtonText (T("Low"));
    lowButton->setRadioGroupId (4);
    lowButton->addButtonListener (this);

    addAndMakeVisible (lastActionLabel = new Label (T("lastActionLabel"),
                                                    String::empty));
    lastActionLabel->setFont (Font (15.0000f, Font::plain));
    lastActionLabel->setJustificationType (Justification::centredLeft);
    lastActionLabel->setEditable (false, false, false);
    lastActionLabel->setColour (TextEditor::textColourId, Colours::black);
    lastActionLabel->setColour (TextEditor::backgroundColourId, Colour (0x0));


    //[UserPreSize]
    //[/UserPreSize]

    setSize (680, 550);

    //[Constructor] You can add your own custom stuff here..

	playerPtr.reset(new sf::Player(handle));
	playerPtr->Initialize();
	if(playerPtr->GetPlaybackMode()){
		pushModeButton->setToggleState(true,false);
	} else {
		eventModeButton->setToggleState(true,false);
	}
	initPlaybackMode(playerPtr->GetPlaybackMode());
	initMMCSSMode(playerPtr->IsMMCSSEnabled());
	if(playerPtr->GetExclusiveMode())
	{
		exclusiveMode->setToggleState(true,false);
	} else {
		sharedMode->setToggleState(true,false);
	}
	repeatModeButton->setToggleState(playerPtr->GetRepeatMode(),false);
	toneGeneratorSource->setToggleState(true,false);
    //[/Constructor]
}

WinAudioComponent::~WinAudioComponent()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    deleteAndZero (lastActionGroup);
    deleteAndZero (CaputureDevicelGroup);
    deleteAndZero (waveFileGroup);
    deleteAndZero (deviceRoleGroup);
    deleteAndZero (playerControl);
    deleteAndZero (DeviceSharing);
    deleteAndZero (playbackMode);
    deleteAndZero (BufferLatency);
    deleteAndZero (playbackDevicelGroup);
    deleteAndZero (playbackVolumeGroup);
    deleteAndZero (playButton);
    deleteAndZero (stopButton);
    deleteAndZero (sharedMode);
    deleteAndZero (exclusiveMode);
    deleteAndZero (playbackVolume);
    deleteAndZero (playbackConsoleButton);
    deleteAndZero (playbackCommunicationsButton);
    deleteAndZero (playbackMultimediaButton);
    deleteAndZero (playbackDeviceCombo);
    deleteAndZero (deviceNameLabel);
    deleteAndZero (pushModeButton);
    deleteAndZero (eventModeButton);
    deleteAndZero (bufferLatencySlider);
    deleteAndZero (latencyLabel1);
    deleteAndZero (latencyLabel100);
    deleteAndZero (latencyLabel50);
    deleteAndZero (audioSourceGroup);
    deleteAndZero (toneGeneratorSource);
    deleteAndZero (waveFileSource);
    deleteAndZero (captureDeviceSource);
    deleteAndZero (waveFileNameText);
    deleteAndZero (fileNameLabel);
    deleteAndZero (selectFileButton);
    deleteAndZero (repeatModeButton);
    deleteAndZero (deviceRoleGroup2);
    deleteAndZero (caputureConsoleButton);
    deleteAndZero (caputureCommunicationsButton2);
    deleteAndZero (caputureMultimediaButton);
    deleteAndZero (caputureDeviceCombo);
    deleteAndZero (deviceNameLabel3);
    deleteAndZero (MMCSSGroup);
    deleteAndZero (enableMMCSSButton);
    deleteAndZero (criticalButton);
    deleteAndZero (normalButton);
    deleteAndZero (highButton);
    deleteAndZero (lowButton);
    deleteAndZero (lastActionLabel);

    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void WinAudioComponent::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.fillAll (Colours::white);

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void WinAudioComponent::resized()
{
    lastActionGroup->setBounds (16, 472, 648, 64);
    CaputureDevicelGroup->setBounds (352, 217, 312, 136);
    waveFileGroup->setBounds (352, 88, 312, 128);
    deviceRoleGroup->setBounds (32, 236, 280, 56);
    playerControl->setBounds (16, 16, 152, 120);
    DeviceSharing->setBounds (176, 16, 152, 120);
    playbackMode->setBounds (16, 352, 312, 112);
    BufferLatency->setBounds (136, 376, 184, 72);
    playbackDevicelGroup->setBounds (16, 216, 312, 136);
    playbackVolumeGroup->setBounds (16, 144, 312, 72);
    playButton->setBounds (48, 48, 88, 24);
    stopButton->setBounds (48, 88, 88, 24);
    sharedMode->setBounds (192, 48, 120, 24);
    exclusiveMode->setBounds (192, 88, 120, 24);
    playbackVolume->setBounds (32, 168, 280, 24);
    playbackConsoleButton->setBounds (40, 256, 80, 24);
    playbackCommunicationsButton->setBounds (216, 256, 88, 24);
    playbackMultimediaButton->setBounds (128, 256, 84, 24);
    playbackDeviceCombo->setBounds (32, 312, 280, 24);
    deviceNameLabel->setBounds (32, 289, 150, 24);
    pushModeButton->setBounds (40, 376, 104, 24);
    eventModeButton->setBounds (40, 408, 104, 24);
    bufferLatencySlider->setBounds (176, 408, 96, 24);
    latencyLabel1->setBounds (144, 412, 32, 16);
    latencyLabel100->setBounds (272, 413, 40, 16);
    latencyLabel50->setBounds (208, 400, 32, 16);
    audioSourceGroup->setBounds (352, 16, 312, 64);
    toneGeneratorSource->setBounds (360, 40, 120, 24);
    waveFileSource->setBounds (480, 40, 88, 24);
    captureDeviceSource->setBounds (560, 40, 96, 24);
    waveFileNameText->setBounds (376, 128, 264, 24);
    fileNameLabel->setBounds (376, 104, 150, 24);
    selectFileButton->setBounds (376, 168, 88, 24);
    repeatModeButton->setBounds (496, 168, 150, 24);
    deviceRoleGroup2->setBounds (368, 237, 280, 56);
    caputureConsoleButton->setBounds (376, 257, 80, 24);
    caputureCommunicationsButton2->setBounds (552, 257, 88, 24);
    caputureMultimediaButton->setBounds (464, 257, 84, 24);
    caputureDeviceCombo->setBounds (368, 313, 280, 24);
    deviceNameLabel3->setBounds (368, 290, 150, 24);
    MMCSSGroup->setBounds (352, 352, 312, 112);
    enableMMCSSButton->setBounds (368, 400, 120, 24);
    criticalButton->setBounds (496, 384, 72, 24);
    normalButton->setBounds (568, 384, 72, 24);
    highButton->setBounds (496, 419, 72, 24);
    lowButton->setBounds (568, 419, 72, 24);
    lastActionLabel->setBounds (32, 496, 616, 24);
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void WinAudioComponent::buttonClicked (Button* buttonThatWasClicked)
{
    //[UserbuttonClicked_Pre]
    //[/UserbuttonClicked_Pre]

    if (buttonThatWasClicked == playButton)
    {
        //[UserButtonCode_playButton] -- add your button handler code here..
		if(toneGeneratorSource->getToggleState())
		{
			playerPtr->Play(sf::eToneGenerator);
		} else if(waveFileSource->getToggleState())
		{
			playerPtr->Play(sf::eWaveFile);
		} else if(captureDeviceSource->getClickingTogglesState())
		{
			playerPtr->Play(sf::eCaptureEndpoint);
		}
        //[/UserButtonCode_playButton]
    }
    else if (buttonThatWasClicked == stopButton)
    {
        //[UserButtonCode_stopButton] -- add your button handler code here..
		playerPtr->Stop();
        //[/UserButtonCode_stopButton]
    }
    else if (buttonThatWasClicked == sharedMode)
    {
        //[UserButtonCode_sharedMode] -- add your button handler code here..
		playerPtr->SetExclusiveMode(false);
        //[/UserButtonCode_sharedMode]
    }
    else if (buttonThatWasClicked == exclusiveMode)
    {
        //[UserButtonCode_exclusiveMode] -- add your button handler code here..
		playerPtr->SetExclusiveMode(true);
        //[/UserButtonCode_exclusiveMode]
    }
    else if (buttonThatWasClicked == playbackConsoleButton)
    {
        //[UserButtonCode_playbackConsoleButton] -- add your button handler code here..
        //[/UserButtonCode_playbackConsoleButton]
    }
    else if (buttonThatWasClicked == playbackCommunicationsButton)
    {
        //[UserButtonCode_playbackCommunicationsButton] -- add your button handler code here..
        //[/UserButtonCode_playbackCommunicationsButton]
    }
    else if (buttonThatWasClicked == playbackMultimediaButton)
    {
        //[UserButtonCode_playbackMultimediaButton] -- add your button handler code here..
        //[/UserButtonCode_playbackMultimediaButton]
    }
    else if (buttonThatWasClicked == pushModeButton)
    {
        //[UserButtonCode_pushModeButton] -- add your button handler code here..
		playerPtr->SetPlaybackMode(true);
		initPlaybackMode(true);
        //[/UserButtonCode_pushModeButton]
    }
    else if (buttonThatWasClicked == eventModeButton)
    {
        //[UserButtonCode_eventModeButton] -- add your button handler code here..
		playerPtr->SetPlaybackMode(false);
		initPlaybackMode(false);
        //[/UserButtonCode_eventModeButton]
    }
    else if (buttonThatWasClicked == toneGeneratorSource)
    {
        //[UserButtonCode_toneGeneratorSource] -- add your button handler code here..
        //[/UserButtonCode_toneGeneratorSource]
    }
    else if (buttonThatWasClicked == waveFileSource)
    {
        //[UserButtonCode_waveFileSource] -- add your button handler code here..
        //[/UserButtonCode_waveFileSource]
    }
    else if (buttonThatWasClicked == captureDeviceSource)
    {
        //[UserButtonCode_captureDeviceSource] -- add your button handler code here..
        //[/UserButtonCode_captureDeviceSource]
    }
    else if (buttonThatWasClicked == selectFileButton)
    {
        //[UserButtonCode_selectFileButton] -- add your button handler code here..
		juce::FileChooser file(L"t@Ce