/*
  ==============================================================================

   This file is part of the S.F.Tracker
   Copyright 2005-7 by Satoshi Fujiwara.

   S.F.Tracker can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   S.F.Tracker is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with S.F.Tracker; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include "includes.h"
#include "STed2Filter.h"
#include "STed2Editor.h"

using namespace juce;
using namespace boost;

namespace sf {

	STed2Filter::STed2Filter()
	{
		numMidiOutputs = 2;
		setPlayConfigDetails(0,0,44100,0);
		startTimer(250);
	};

	void STed2Filter::fillInPluginDescription (juce::PluginDescription& d) const
	{
		d.name = getName();
		d.uid = d.name.hashCode();
		d.category = "I/O devices";
		d.pluginFormatName = "Internal";
		d.manufacturerName = "SFPGMR";
		d.version = "1.0";
		d.isInstrument = false;

		d.numInputChannels = getNumInputChannels();
		d.numOutputChannels = getNumOutputChannels();

	};

	void STed2Filter::prepareToPlay (double sampleRate, int estimatedSamplesPerBlock)
	{
		setPlayConfigDetails(getNumInputChannels(),getNumOutputChannels(),sampleRate,estimatedSamplesPerBlock);
	};

	void STed2Filter::releaseResources()
	{
	};

	void STed2Filter::processBlock (juce::AudioSampleBuffer& buffer, juce::Array<MidiBuffer*>& midiMessages)
	{
	};





juce::AudioProcessorEditor* STed2Filter::createEditor()
{
	return new juce::STEd2Editor(this);
};


void STed2Filter::getStateInformation (JUCE_NAMESPACE::MemoryBlock& destData)
{
	// ɕۑ
	//std::wstringstream s;
	//boost::archive::xml_woarchive oa(s);
	//oa & serialization::make_nvp("STed2Filter",*this);
	//DBG(s.str().c_str());
	//destData.setSize(sizeof(wchar_t) * (s.str().size() + 1));
	//destData.copyFrom(s.str().c_str(),0,sizeof(wchar_t) * (s.str().size() + 1));
}

void STed2Filter::setStateInformation (const void* data, int sizeInBytes)
{
//	std::wstringstream st;
//	st << (wchar_t*)data;
//	boost::archive::xml_wiarchive ia(st);
//	ia & serialization::make_nvp("STed2Filter",*this);
////			juce::DBG(L"setStateInformation " + juce::String(testState));
};

template<class Archive>
void STed2Filter::save(Archive & ar, const unsigned int version) const
{
};

template<class Archive>
void STed2Filter::load(Archive & ar, const unsigned int version)
{
};


}

