﻿/*
  hprint.c

  functions for compatibility in hprint.s
  "extremely fast print functions"

  H_INIT , H_PRINT , H_PRINT2

  Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "sted.h"
#include "sted_screen.h"


void
H_INIT ( void )
{

  /* not implemented */
  return;
}

void
H_PRINT ( char *in_s1, char *in_s2, char *in_s3 )
{
  CSTedScreenBase* scr;
  int x,y;
  int l=0;
  int c;

  scr = GetDriver();
  if (!scr) return;

  x=B_LOCATE(-1,0);
  y=x&0xffff;
  x=x>>16;

  scr->Locate(0, y);
  scr->ClsEol();

  scr->Locate(x,y);
  if (in_s1) {
    c = scr->SetTextColor(3);
    scr->Puts(in_s1);
    scr->SetTextColor(c);
    l = strlen(in_s1);
  }

  if (in_s2) {
    c = scr->SetTextColor(2);
    scr->Puts(in_s2);
    scr->SetTextColor(c);
    l+=strlen(in_s2);
  }

  if (in_s3) {
    c = scr->SetTextColor(1);
    scr->Puts(in_s3);
    scr->SetTextColor(c);
    l+=strlen(in_s3);
  }

  B_LOCATE(x+l,y);

  return;
}

void
H_PRINT2 ( char *in_s1, char *in_s2, char *in_s3 )
{
  CSTedScreenBase* scr;
  int x,y;
  int l=0;
  int c;

  scr = GetDriver();
  if (!scr) return;

  x=B_LOCATE(-1,0);
  y=x&0xffff;
  x=x>>16;

  scr->Locate(x,y);
  if (in_s1) {
    c = scr->SetTextColor(3);
    scr->Puts(in_s1);
    scr->SetTextColor(c);
    l = strlen(in_s1);
  }

  if (in_s2) {
    c = scr->SetTextColor(c);
    scr->Puts(in_s2);
    scr->SetTextColor(c);
    l+=strlen(in_s2);
  }

  if (in_s3) {
    c = scr->SetTextColor(c);
    scr->Puts(in_s3);
    scr->SetTextColor(c);
    l+=strlen(in_s3);
  }

  B_LOCATE(x+l,y);
  return;
}

