package org.wicketja.pages;

import javax.persistence.EntityManager;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.wicketja.WicketApplication;

/**
 * 全てのページに共通的な処理を提供する抽象クラスです。
 * @author Yoichiro Tanaka
 */
@SuppressWarnings("serial")
public abstract class AbstractWebPage extends WebPage {

    EntityManager entityManager = null;
    
    /**
     * このオブジェクトが生成されるときに呼び出されます。
     */
    public AbstractWebPage() {
        this(null);
    }

    /**
     * このオブジェクトが生成されるときに呼び出されます。
     * @param model モデルオブジェクト
     */
    public AbstractWebPage(IModel model) {
        super(model);
        add(new NavigationHeaderPanel("mainNavigation", getTitle()));
    }

    /**
     * このページのタイトルを返します。
     * @return ページのタイトルとする文字列
     */
    protected String getTitle() {
        return getString("pageName");
    }

    protected EntityManager getEntityManager() {
        if(entityManager == null) {
            WicketApplication app = (WicketApplication)getApplication();
            entityManager = app.getEntityManagerFactory().createEntityManager();
        }
        return entityManager;
    }

    @Override
    protected void onDetach() {
        if(entityManager != null) {
            entityManager.close();
        }
        
        super.onDetach();
    }
}
