package org.wicketja.model;

import java.io.Serializable;
import java.util.Calendar;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;

import javax.persistence.Table;
import org.wicketja.model.vo.Category;

/**
 * １件のリンクを表します。
 * 
 * @author s_tonouchi
 * @author Tsutomu YANO
 * 
 */
@SuppressWarnings("serial")
@Entity
@Table(name = "LINK_ITEM", schema = "WICKETJA")
public class LinkItem implements Serializable {

    private Integer id;
    /**
     * リンクしたサイトの名前
     */
    private String name;
    /**
     * リンクした先のURL
     */
    private String url;
    /**
     * リンク先の紹介文
     */
    private String excerpt;
    /**
     * カテゴリー
     */
    private Category category;
    /**
     * リンクが登録された日付
     */
    private Calendar registerDate;
    /**
     * RSSへのURL
     */
    private String feedUrl;
    /**
     * 登録解除日時
     */
    private Calendar unregisterDate;

    public LinkItem() {

    }

    public LinkItem(String name, String url, String excerpt, Category category,
            String feedUrl, Calendar registered) {
        this.category = category;
        this.excerpt = excerpt;
        this.feedUrl = feedUrl;
        this.name = name;
        this.registerDate = registered;
        this.url = url;
    }

    @Id
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(nullable = false)
    public String getName() {
        return name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Column(length = 2048)
    public String getUrl() {
        return url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    @Column(length = 2048)
    public String getExcerpt() {
        return excerpt;
    }

    void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    @Column(nullable = false)
    @Enumerated(EnumType.STRING)
    public Category getCategory() {
        return category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    @Column(length = 2048)
    public String getFeedUrl() {
        return feedUrl;
    }

    public void setFeedUrl(String feedUrl) {
        this.feedUrl = feedUrl;
    }

    @Column(nullable = false)
    public Calendar getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Calendar registered) {
        this.registerDate = registered;
    }

    public Calendar getUnregisterDate() {
        return unregisterDate;
    }

    public void setUnregisterDate(Calendar unregistered) {
        this.unregisterDate = unregistered;
    }
}
