package org.wicketja.dao;

import java.io.Serializable;
import java.util.List;

import javax.persistence.EntityManager;
import org.wicketja.model.LinkItem;

/**
 * リンク集ページに表示するリンクの一覧を取得するためのクラス
 * 
 * @author s_tonouchi
 * @author Tsutomu YANO
 * 
 */
@SuppressWarnings("serial")
public class LinkDaoImpl implements Serializable, LinkDao {

    EntityManager em;

    public LinkDaoImpl(EntityManager em) {
        this.em = em;
    }

    /* (non-Javadoc)
     * @see org.wicketja.site.links.LinkDao#findAll()
     */
    @SuppressWarnings("unchecked")
    public List<LinkItem> findAll() {
        return em.createQuery("select link from LinkItem as link where link.unregisterDate is null order by link.registerDate desc").getResultList();
//        List<LinkItem> links = new ArrayList<LinkItem>();
//        
//        Calendar calendar1 = Calendar.getInstance();
//        calendar1.set(2008, Calendar.FEBRUARY, 11);
//        links.add(new LinkItem("Apache Wicket", "http://wicket.apache.org/",
//                "Wicketを開発している団体です。", Category.COMMUNITY, "", calendar1));
//
//        Calendar calendar2 = Calendar.getInstance();
//        calendar2.set(2008, Calendar.FEBRUARY, 18);
//        links.add(new LinkItem("Wicket Stuff wiki",
//                "http://wicketstuff.org/confluence/display/STUFFWIKI/Wiki",
//                "Wicketの様々なComponentが公開されています。", Category.COMMUNITY, "", calendar2));
//
//        return links;
    }

}
