package org.wicketja.pages;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;

/**
 * Wicket-JAサイトのためのナビゲーションパネルクラスです。
 * @author Yoichiro Tanaka
 */
@SuppressWarnings("serial")
public final class NavigationHeaderPanel extends Panel {
	

	/**
	 * このオブジェクトが生成されるときに呼び出されます。
	 * @param id wicket:id値
	 * @param title タイトル文字列
	 */
	public NavigationHeaderPanel(String id, String title) {
		super(id);
		// タイトルをセット
		add(new Label("title", title));
		// 各種リンクを設置
		setupLinks();
	}
		
	private void setupLinks() {
		// トップページリンクの設置
		add(new BookmarkablePageLink("top", HomePage.class));
		add(new BookmarkablePageLink("toTop", HomePage.class));
		
		// Newsリンクの設置
		add(new BookmarkablePageLink("news", NewsPage.class));
		// FAQリンクの設置
		add(new BookmarkablePageLink("faq", FaqPage.class));
		// リンク集リンクの設置
		add(new BookmarkablePageLink("links", LinksPage.class));
	}
	
}
