﻿module.exports = {
	enable_profile : true,	//プロファイル機能を使用するなら真。そうでないなら、偽

	port : process.env.port || 3000,	//ポート

	redisHost : "localhost",	//redisサーバのアドレス
	redisPort : 6379,	//redisサーバのポート
	redisPassword : "",	//redisサーバのパスワード

	db_user : "user",	//MySQLサーバーのユーザー名
	db_password : "user",	//MySQLサーバーのパスワード
	db_host : "localhost",	//MySQLサーバーのアドレス
	db_port : 3306,	//MySQLサーバーのポート
	db_name : "webchat",	//データーベース名
	db_limit : 50,	//一度に表示する件数

	username : "admin",	//管理者用のページにアクセスできるユーザ名
	password : "admin",	//管理者用のページにアクセスするのに必要なパスワード

	max_room_number : 3,	//最大ルーム数

	showip : false,	//IPアドレスを表示するなら真。そうでないなら、偽

	transports : ["websocket",	//通信方式
		"htmlfile",
		"xhr-polling"],

	//詳細画面と編集画面に表示するフィールド名と表示名の組み合わせおよびテーブル定義
	//表示される順番はこの変数によって決まります
	//
	//name 表示名を指定する
	//type データ型を指定する。指定可能な型は以下の通り
	//	text	文字列型を受け付ける
	//	password	パスワードとして指定できるものを受け付ける。デフォルトではすべての文字列です
	//	number	符号付数値型を受け付ける
	//	unsignednumber	符号なし数値型を受け付ける
	//	textarea	改行を含む文字列型を受け付ける
	//	bool	BOOL型を受け付ける
	//	datetime	DATETIME型を受け付ける
	//length 長さを指定する
	//	numberの場合、2がSMALLINT、4がINTに対応する
	//	textとpasswordの場合、最大長を指定する
	//defaultvalue デフォルト値を指定する
	//primary プライマリーキーとして指定するなら真。そうでないなら偽
	//isnotempty 真なら必須メンバーであることを表し、そうでないなら空欄でも構わないことを表す
	//isnotemptyonregistor 真なら登録時に必須メンバーであることを表し、そうでないなら空欄でも構わないことを表す
	//nodefinetable 真ならテーブルの項目に登録しないことを表し、そうでないなら登録することを表す
	//visible 詳細画面に表示するなら真。そうでないなら偽
	//visible_registor 登録画面に表示するなら真。そうでないなら偽
	//visible_edit 編集画面に表示するなら真。そうでないなら偽
	//readonly 編集画面で編集できないようにするなら真。そうでないなら偽（typeがpasswordの場合は無視されます）
	//mustmatchitem 登録時に一致しなければならない項目を指定する（編集時に一致しない場合は無視されます）
	//rule バリテーション時に実行される関数を指定する
	// 呼び出される関数の第一パラメーターはバリテーションの対象となるデーターで、第二パラメーターはデーター型となる
	// 実行される関数でバリテーションが成功した場合、nullを返さなければならない
	alias : {
	//name以外の項目を編集しないでください。正常に動作しなくなります
	//ここから
		name_hash:
			{
				name : "名前（ハッシュ）",
				type : "unsignednumber",
				length : 4,
				primary : true,
				visible : false,
				visible_edit : false,
				visible_registor : false,
				isnotempty : true
			},
		name :
			{
				name : "名前",
				type : "text",
				visible : false,
				visible_edit : true,
				visible_registor : true,
				readonly : true,
				length : 64,
				isnotempty : true
			},
		password :
			{
				name : "パスワード",
				type : "password",
				length : 32,
				visible : false,
				visible_edit : true,
				visible_registor : true,
				isnotemptyonregistor : true
			},
		newpassword :
			{
				name : "パスワード確認",
				type : "password",
				length : 32,
				visible : false,
				visible_edit : true,
				visible_registor : true,
				mustmatchitem : "password",
				nodefinetable : true,
			},
		lastmodified :
			{
				name : "更新日付",
				type : "datetime",
				visible : false,
				visible_edit : false,
				visible_registor : false,
			},
	//ここまで
		mailto :
			{
				name : "メールアドレス",
				type : "mail",
				length : 255,
				visible : false,
				visible_edit : true,
				visible_registor : true,
			},
		age :
			{
				name : "年齢",
				type : "number",
				defaultvalue : 0,
				length : 2,
				visible : true,
				visible_edit : true,
				visible_registor : true,
			},
		height :
			{
				name : "身長",
				type : "text",
				defaultvalue : 0,
				length : 64,
				visible : true,
				visible_edit : true,
				visible_registor : true,
			},
		weight :
			{
				name : "体重",
				type : "text",
				defaultvalue : 0,
				length : 64,
				visible : true,
				visible_edit : true,
				visible_registor : true,
			},
		gender :
			{
				name : "性別",
				type : "text",
				length : 8,
				visible : true,
				visible_edit : true,
				visible_registor : true,
			},
		race :
			{
				name : "種族",
				type : "text",
				length : 64,
				visible : true,
				visible_edit : true,
				visible_registor : true,
			},
		etc :
			{
				name : "備考",
				type : "textarea",
				visible : true,
				visible_edit : true,
				visible_registor : true,
			},
	},
};

