package jp.co.headwaters.webappos.controller.utils;

import jp.co.headwaters.webappos.controller.ControllerConstants;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractFunctionBean;

public class ControllerUtils {

	public static String getFileSparator() {
		return System.getProperty("file.separator"); //$NON-NLS-1$
	}

	public static String getPageElementName(AbstractFunctionBean function) {
		StringBuilder sb = new StringBuilder();
		sb.append(function.getResult());
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_CRUD_PAGE_NO);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		return sb.toString();
	}

	public static String getSortElementName(AbstractFunctionBean function) {
		StringBuilder sb = new StringBuilder();
		sb.append(function.getResult());
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_CRUD_SORT);
		sb.append(ControllerConstants.REQUEST_PARAM_NAME_DELIMITER);
		return sb.toString();
	}

}
