package jp.co.headwaters.webappos.controller.enumation;

/**
 * CRUD処理を表す列挙子
 */
public enum CrudEnum {

	/** Exampleを指定してヒット件数を取得する */
	CRUD_COUNT("count", "countByExample"), //$NON-NLS-1$ //$NON-NLS-2$
	/** keyを指定してレコードを取得する(対象テーブルのみ) */
	CRUD_SELECT_BY_PRIMARYKEY("selectByPk", "selectByPrimaryKey"), //$NON-NLS-1$ //$NON-NLS-2$
	/** keyを指定してレコードを取得する(参照テーブル含む) */
	CRUD_SELECT_ALL_BY_PRIMARYKEY("selectAllByPk", "selectAllByPrimaryKey"), //$NON-NLS-1$ //$NON-NLS-2$
	/** Exampleを指定してレコードを取得する(対象テーブルのみ) */
	CRUD_SELECT_BY_EXAMPLE("select", "selectByExample"), //$NON-NLS-1$ //$NON-NLS-2$
	/** Exampleを指定してレコードを取得する(参照テーブル含む) */
	CRUD_SELECT_ALL_BY_EXAMPLE("selectAll", "selectAllByExample"), //$NON-NLS-1$ //$NON-NLS-2$
	/** 登録 */
	CRUD_INSERT("insert", "insertSelective"), //$NON-NLS-1$ //$NON-NLS-2$
	/** Exampleを指定して更新する */
	CRUD_UPDATE("update", "updateByExampleSelective"), //$NON-NLS-1$ //$NON-NLS-2$
	/** keyを指定して更新する */
	CRUD_UPDATE_BY_PRIMARYKEY("updateByPrimaryKey", "updateByPrimaryKeySelective"), //$NON-NLS-1$ //$NON-NLS-2$
	/** Exampleを指定して削除する */
	CRUD_DELETE("delete", "deleteByExample"), //$NON-NLS-1$ //$NON-NLS-2$
	/** keyを指定して削除する */
	CRUD_DELETE_BY_PRIMARYKEY("deleteByPrimaryKey", "deleteByPrimaryKey"); //$NON-NLS-1$ //$NON-NLS-2$

	private String method;
	private String statementId;

	private CrudEnum(final String method, final String statementId) {
		this.method = method;
		this.statementId = statementId;
	}

	public static CrudEnum getCrud(final String method) {
		for (CrudEnum e : CrudEnum.values()) {
			if (method.equals(e.getMethod())) {
				return e;
			}
		}
		throw new IllegalArgumentException(method);
	}

	public String getMethod() {
		return this.method;
	}

	public String getStatementId() {
		return this.statementId;
	}
}
