package jp.co.headwaters.webappos.controller.cache.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SubmitFunctionBean extends AbstractFunctionBean implements Serializable {

	private static final long serialVersionUID = -1040766031569355155L;

	@JsonProperty("TYPE")
	private String type;

	// --- 以降のプロパティは、crudの場合のみ使用する
	/**
	 * テーブル.カラム別に演算子を保持するMap<br>
	 * 属性のJSONパラメータを元に生成する<br>
	 * Submit時にパラメータに含まれるテーブル名、カラム名から演算子を取得する為に使用する<br>
	 * セキュリティ保護の為、パラメータ名によって演算子は導出せず、キャッシュから取得する
	 */
	private Map<String, String> operatorMap;

	// --- 以降のプロパティは、sendmailの場合のみ使用する
	@JsonProperty("TO")
	private List<String> tos;
	@JsonProperty("CC")
	private List<String> ccs;
	@JsonProperty("BCC")
	private List<String> bccs;
	@JsonProperty("ID_COL")
	private String toIdColumnName;
	@JsonProperty("ADDRESS_COL")
	private String toAddressColumnName;

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Map<String, String> getOperatorMap() {
		return this.operatorMap;
	}

	public void setOperatorMap(Map<String, String> operatorMap) {
		this.operatorMap = operatorMap;
	}

	public List<String> getTos() {
		return this.tos;
	}

	public void setTos(List<String> tos) {
		this.tos = tos;
	}

	public List<String> getCcs() {
		return this.ccs;
	}

	public void setCcs(List<String> ccs) {
		this.ccs = ccs;
	}

	public List<String> getBccs() {
		return this.bccs;
	}

	public void setBccs(List<String> bccs) {
		this.bccs = bccs;
	}

	public String getToIdColumnName() {
		return this.toIdColumnName;
	}

	public void setToIdColumnName(String toIdColumnName) {
		this.toIdColumnName = toIdColumnName;
	}

	public String getToAddressColumnName() {
		return this.toAddressColumnName;
	}

	public void setToAddressColumnName(String toAddressColumnName) {
		this.toAddressColumnName = toAddressColumnName;
	}
}
