package jp.co.headwaters.webappos.controller.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.headwaters.webappos.controller.ControllerConstants;
import jp.co.headwaters.webappos.controller.model.SchemaColumn;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;

import org.apache.ibatis.session.SqlSession;

public class SchemaColumnCache {

	private static final SchemaColumnCache _instance = new SchemaColumnCache();
	private Map<String, SchemaColumn> _map;

	private SchemaColumnCache() {
	}

	public static SchemaColumnCache getInstance() {
		return _instance;
	}

	public void refresh() {
		List<SchemaColumn> schemaColumn = null;
		try (
				SqlSession session = DaoUtils.getSqlSessionFactory().openSession()) {
			schemaColumn = session.selectList(ControllerConstants.SYSTEM_SCHEMA_COLUMN_SEL_STATEMENT,
					PropertyUtils.getProperty(ControllerConstants.PROPERTY_KEY_CONTEXT_NAME));
		}

		this._map = new HashMap<String, SchemaColumn>();
		if (schemaColumn != null) {
			for (SchemaColumn col : schemaColumn) {
				if (this._map.containsKey((col.getColumnName()))) {
					// TODO:ワーニング出す
				}
				this._map.put(col.getColumnName(), col);
			}
		} else {
			// TODO:ワーニング出す
		}
	}

	public SchemaColumn getSchemaColumn(String colName) {
		return this._map.get(colName);
	}
}
