package jp.co.headwaters.webappos.controller;


public class ControllerConstants {

	// ----------------------------------------------------------
	// Common
	// ----------------------------------------------------------
	public static final String PATH_DELIMITER = "/"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for config
	// ----------------------------------------------------------
	/** MyBatis設定ファイル名 */
	public static final String MYBATIS_CONFIG_FILE_NAME = "mybatis-config.xml"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for message
	// ----------------------------------------------------------
	public static final String MESSAGE_BUNDLE_NAME = "messages"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for properties
	// ----------------------------------------------------------
	/** プロパティファイル名 */
	public static final String PROPERTY_FILE_NAME = "webappos.properties"; //$NON-NLS-1$
	/** パッケージ */
	public static final String PROPERTY_KEY_ROOT_PACKAGE = "root.package"; //$NON-NLS-1$
	/** コンテキスト名 */
	public static final String PROPERTY_KEY_CONTEXT_NAME = "context.name"; //$NON-NLS-1$
	/** Webアプリ参照ディレクトリPath */
	public static final String PROPERTY_KEY_WEBAPPS_PATH = "webapps.path"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for webapps
	// ----------------------------------------------------------
	/** DAT格納ディレクトリ名 */
	public static final String WEBAPPS_DAT_DIR = "dat"; //$NON-NLS-1$
	/** action cacheファイル名 */
	public static final String ACTION_DAT_FILE_NAME = "action.dat"; //$NON-NLS-1$
	/** url pattern cacheファイル名 */
	public static final String URL_PATTERN_DAT_FILE_NAME = "url.dat"; //$NON-NLS-1$
	/** メールテンプレート格納ディレクトリ名 */
	public static final String WEBAPPS_MAIL_TEMPLATE_DIR = "templates"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for db
	// ----------------------------------------------------------
	/** PKカラム名 */
	public static final String PK_COLUMN_NAME = "id"; //$NON-NLS-1$
	/** 登録日時カラム名 */
	public static final String CREATED_COLUMN_NAME = "created"; //$NON-NLS-1$
	/** 更新日時カラム名 */
	public static final String UPDATED_COLUMN_NAME = "updated"; //$NON-NLS-1$

	/** MyBatisのMapperファイルのサフィックス */
	public static final String MYBATIS_MAPPER_SUFFIX = "Mapper"; //$NON-NLS-1$
	/** 自動生成するModelクラスのパッケージ名 */
	public static final String MYBATIS_MODEL_PACKAGE = "model"; //$NON-NLS-1$
	/** 自動生成するMapperファイルのパッケージ名 */
	public static final String MYBATIS_MAPPER_PACKAGE = "mapper"; //$NON-NLS-1$

	/** システム定数情報のSelectステートメント名 */
	public static final String SYSTEM_CONSTANT_SEL_STATEMENT = "SystemConstantMapper.selectAll"; //$NON-NLS-1$
	/** カラム情報のSelectステートメント名 */
	public static final String SYSTEM_SCHEMA_COLUMN_SEL_STATEMENT = "SchemaColumnMapper.selectAll"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for request parse
	// ----------------------------------------------------------
	/** form識別子の要素名 */
	public static final String ELEMENT_NAME_FORM_ID = "_SYS_FORM_ID_"; //$NON-NLS-1$
	/** パラメータ名のデリミタ */
	public static final String REQUEST_PARAM_NAME_DELIMITER = "__"; //$NON-NLS-1$
	/** CRUDの登録、更新要素のパラメータ識別子 */
	public static final String REQUEST_PARAM_NAME_CRUD_COLUMN = "COL"; //$NON-NLS-1$
	/** CRUDの条件要素のパラメータ識別子 */
	public static final String REQUEST_PARAM_NAME_CRUD_CONDITION = "COND"; //$NON-NLS-1$
	/** CRUDのソート要素のパラメータ識別子 */
	public static final String REQUEST_PARAM_NAME_CRUD_SORT = "SORT"; //$NON-NLS-1$
	/** CRUDのソート要素のパラメータ識別子 */
	public static final String REQUEST_PARAM_NAME_CRUD_PAGE_NO = "PAGE_NO"; //$NON-NLS-1$
	/** リクエストパラメータ格納時のKey */
	public static final String REQUEST_PARAM_MAP_KEY = "_REQ"; //$NON-NLS-1$
	/** result識別子の属性名 */
	public static final String ATTR_NAME_RESULT_NAME = "_RESULT_NAME_"; //$NON-NLS-1$

	/** URIからパラメータを抽出する為の正規表現 */
	public static final String REGEX_REQUEST_PARAM = "[-_.!~*()a-zA-Z0-9%]+/\\(\\.\\+\\)"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for response
	// ----------------------------------------------------------
	/** result省略時のデフォルト */
	public static final String DEFAULT_RESULT_NAME = "index"; //$NON-NLS-1$
	/** jspファイルの拡張子 */
	public static final String JSP_EXTENSION = ".jsp"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for crud
	// ----------------------------------------------------------
	public static final String CRUD_IN_DELIMITER = ","; //$NON-NLS-1$

	public static final String CRUD_PAGER_NAME = "PAGE_INFO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_RECORD_COUNT = "RECORD_COUNT"; //$NON-NLS-1$
	public static final String CRUD_PAGER_PER_PAGE = "PER_PAGE"; //$NON-NLS-1$
	public static final String CRUD_PAGER_RECORD_BEGIN_NO = "RECORD_BEGIN_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_RECORD_END_NO = "RECORD_END_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_PAGE_NO = "PAGE_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_PREV_PAGE_NO = "PREV_PAGE_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_NEXT_PAGE_NO = "NEXT_PAGE_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_PAGING_BEGIN_NO = "PAGING_BEGIN_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_PAGING_END_NO = "PAGING_END_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_MAX_PAGE_NO = "MAX_PAGE_NO"; //$NON-NLS-1$
	public static final String CRUD_PAGER_PAGE_NO_LIST = "PAGE_NO_LIST"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for pager
	// ----------------------------------------------------------
	public static final int DEFAULT_PEGE_NO = 1;
	public static final String DEFAULT_PER_PAGE = "20"; //$NON-NLS-1$
	public static final String DEFAULT_PAGER_COUNT = "5"; //$NON-NLS-1$

	// ----------------------------------------------------------
	// for html attribute
	// ----------------------------------------------------------
	// OPE
	public static final String HTML_OPERATOR_NULL = " isnull "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_NOT_NULL = " isnotnull "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_EQUAL = " eq "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_NOT_EQUAL = " nq "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_GREATER_THAN = " gt "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_GREATER_OR_EQUAL = " ge "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_LESS_THAN = " lt "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_LESS_OR_EQUAL = " le "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_FRONT_LIKE = " %like "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_MIDDLE_LIKE = " %like% "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_BACK_LIKE = " like% "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_FRONT_NOT_LIKE = " %notlike "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_MIDDLE_NOT_LIKE = " %notlike% "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_BACK_NOT_LIKE = " notlike% "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_IN = " in "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_NOT_IN = " notin "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_BETWEEN = " between "; //$NON-NLS-1$
	public static final String HTML_OPERATOR_NOT_BETWEEN = " notbetween "; //$NON-NLS-1$
	// OPT
	public static final String HTML_OPTION_FROM = "from"; //$NON-NLS-1$
	public static final String HTML_OPTION_TO = "to"; //$NON-NLS-1$

}
