package jp.co.headwaters.webappos.controller;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import jp.co.headwaters.webappos.controller.cache.ActionCache;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.SystemConstantCache;
import jp.co.headwaters.webappos.controller.cache.UrlPatternCache;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppilicationInitializer implements ServletContextListener {

	private static final Log _logger = LogFactory.getLog(AppilicationInitializer.class);

	public void contextInitialized(ServletContextEvent event) {
		try {
			_logger.info("WEB APP OS contextInitialize start"); //$NON-NLS-1$

			_logger.info("Property Load start"); //$NON-NLS-1$
			PropertyUtils.load();
			_logger.info("Property Load end"); //$NON-NLS-1$

			_logger.info("Action Cache Load start"); //$NON-NLS-1$
			ActionCache actionCache = ActionCache.getInstance();
			actionCache.load();
			_logger.info("Action Cache Load  start"); //$NON-NLS-1$

			_logger.info("Url Pattern Cache Load start"); //$NON-NLS-1$
			UrlPatternCache urlPatternCache = UrlPatternCache.getInstance();
			urlPatternCache.load();
			_logger.info("Url Pattern Cache Load  start"); //$NON-NLS-1$

			_logger.info("SchemaColumn Cache Refresh start"); //$NON-NLS-1$
			// スキーマ情報をキャッシュする
			SchemaColumnCache schemaColumnCache = SchemaColumnCache.getInstance();
			schemaColumnCache.refresh();
			_logger.info("SchemaColumn Cache Refresh end"); //$NON-NLS-1$

			_logger.info("SystemConstant Cache Refresh start"); //$NON-NLS-1$
			// system_constant情報をキャッシュする
			SystemConstantCache systemConstantCache = SystemConstantCache.getInstance();
			systemConstantCache.refresh();
			_logger.info("SystemConstant Cache Refresh end"); //$NON-NLS-1$

			_logger.info("WEB APP OS contextInitialize end"); //$NON-NLS-1$
		} catch (Exception e) {
			// Webアプリケーション起動を中止する
			throw new Error(e);
		}
	}

	@Override
	public void contextDestroyed(ServletContextEvent arg0) {
		// nothing
	}
}