/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.result;

import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

public class DefaultMapResultHandler<K, V>
implements ResultHandler {
    private final Map<K, V> mappedResults;
    private final String mapKey;
    private final ObjectFactory objectFactory;
    private final ObjectWrapperFactory objectWrapperFactory;

    public DefaultMapResultHandler(String mapKey, ObjectFactory objectFactory, ObjectWrapperFactory objectWrapperFactory) {
        this.objectFactory = objectFactory;
        this.objectWrapperFactory = objectWrapperFactory;
        this.mappedResults = objectFactory.create(Map.class);
        this.mapKey = mapKey;
    }

    @Override
    public void handleResult(ResultContext context) {
        Object value = context.getResultObject();
        MetaObject mo = MetaObject.forObject(value, this.objectFactory, this.objectWrapperFactory);
        Object key = mo.getValue(this.mapKey);
        this.mappedResults.put(key, value);
    }

    public Map<K, V> getMappedResults() {
        return this.mappedResults;
    }
}

