/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.test.StubConfigurationProvider;
import com.opensymphony.xwork2.util.XWorkTestCaseHelper;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWorkTestCase
extends TestCase {
    protected ConfigurationManager configurationManager;
    protected Configuration configuration;
    protected Container container;
    protected ActionProxyFactory actionProxyFactory;

    protected void setUp() throws Exception {
        this.configurationManager = XWorkTestCaseHelper.setUp();
        this.configuration = this.configurationManager.getConfiguration();
        this.container = this.configuration.getContainer();
        this.actionProxyFactory = this.container.getInstance(ActionProxyFactory.class);
    }

    protected void tearDown() throws Exception {
        XWorkTestCaseHelper.tearDown(this.configurationManager);
        this.configurationManager = null;
        this.configuration = null;
        this.container = null;
        this.actionProxyFactory = null;
    }

    protected void loadConfigurationProviders(ConfigurationProvider ... providers) {
        this.configurationManager = XWorkTestCaseHelper.loadConfigurationProviders(this.configurationManager, providers);
        this.configuration = this.configurationManager.getConfiguration();
        this.container = this.configuration.getContainer();
        this.actionProxyFactory = this.container.getInstance(ActionProxyFactory.class);
    }

    protected void loadButAdd(Class<?> type, Object impl) {
        this.loadButAdd(type, "default", impl);
    }

    protected void loadButAdd(final Class<?> type, final String name, final Object impl) {
        this.loadConfigurationProviders(new StubConfigurationProvider(){

            public void register(ContainerBuilder builder, LocatableProperties props) throws ConfigurationException {
                builder.factory(type, name, new Factory(){

                    public Object create(Context context) throws Exception {
                        return impl;
                    }
                }, Scope.SINGLETON);
            }
        });
    }
}

