package jp.co.headwaters.webappos.common.enumation;

/**
 * DBのデータ型を表す列挙子
 */
public enum DataTypeEnum {

	DATA_TYPE_SMALLINT("smallint"),
	DATA_TYPE_INTEGER("integer"),
	DATA_TYPE_BIGINT("bigint"),
	DATA_TYPE_NUMERIC("numeric"),
	DATA_TYPE_REAL("real"),
	DATA_TYPE_DOUBLE_PRECISION("double precision"),
	DATA_TYPE_CHARACTER_VARYING("character varying"),
	DATA_TYPE_CHARACTER("character"),
	DATA_TYPE_TEXT("text"),
	DATA_TYPE_TIMESTAMP_WITHOUT_TIME_ZONE("timestamp without time zone"),
	DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE("timestamp with time zone"),
	DATA_TYPE_DATE("date"),
	DATA_TYPE_TIME_WITHOUT_TIME_ZONE("time without time zone"),
	DATA_TYPE_TIME_WITH_TIME_ZONE("time with time zone"),
	DATA_TYPE_BYTEA("bytea"),
	DATA_TYPE_BOOLEAN("boolean"),
	DATA_TYPE_BIT("bit"),
	DATA_TYPE_BIT_VARYING("bit varying");

	private String type;

	private DataTypeEnum(final String type) {
		this.type = type;
	}

	public static DataTypeEnum getDataType(final String type) {
		for (DataTypeEnum e : DataTypeEnum.values()) {
			if (type.equals(e.getDataType())) {
				return e;
			}
		}
		throw new IllegalArgumentException(type);
	}

	public String getDataType() {
		return this.type;
	}

}
