package jp.co.headwaters.webappos.common;


public class AppConstants {

	/** パラメータ名のデリミタ */
	public static final String REQUEST_PARAM_NAME_DELIMITER = "__";
	/** 変換後パラメータ名のデリミタ */
	public static final String REQUEST_PARAM_NAME_DELIMITER_REPLACEMENT = "_";

	/** 遷移先名 */
	public static final String REQUEST_PARAM_NAME_RESULT_NAME = "result_name";
	/** デフォルトの遷移先名 */
	public static final String DEFAULT_RESULT_NAME = "success";

	/** CRUDの登録、更新カラム指定 */
	public static final String REQUEST_PARAM_NAME_CRUD_COLUMN = "col";
	/** CRUDの条件指定 */
	public static final String REQUEST_PARAM_NAME_CRUD_CONDITION = "cond";
	/** CRUDのソート指定 */
	public static final String REQUEST_PARAM_NAME_CRUD_SORT = "sort";


	// メールテンプレート(freeMarke)配置場所
	public static final String MAIL_TEMPLATE_PATH = "C:\\dev\\workspace_webappos\\webAppOS\\templates";

	// TODO:後でpropertiesに移動。エンコード
	public static final String HTML_ENCODING = "UTF-8";

	// TODO:後でpropertiesに移動。htmlの配置場所を設定する
	// System.getProperty("file.separator")
	public static final String HTML_BASE_PATH = "C:\\dev\\workspace_webappos\\webAppOS\\html\\";

	// TODO:後でpropertiesに移動。プロジェクトのディレクトリを設定する
	public static final String PROJECT_BASE_PATH = "C:\\dev\\workspace_webappos\\webAppOS\\";

	// TODO:後でpropertiesに移動。Webアプリケーションのルートとするディレクトリを設定する
	public static final String WEB_ROOT_DIR = "web";

	// TODO:後でpropertiesに移動。プロパティファイル格納ディレクトリ
	public static final String PROPERTY_DIR = "properties\\";

	// TODO:後でpropertiesに移動。mapperファイル格納ディレクトリ
	public static final String MAPPER_DIR = "mappers\\";

	// TODO:後でpropertiesに移動。デフォルトjspファイル名
	public static final String DEFAULT_RESULT_FILE_NAME = "\\index.jsp";

	/** jspの配置パス(Webルートからの相対パス) */
	public static final String JSP_DIR = "jsp\\";

	/** ビルド出力用パス(Webルートからの相対パス) */
	public static final String OUTPUT_DIR_PATH = "\\WEB-INF\\classes\\";

	/** WebAppOSのstruts2設定ファイル名 */
	public static final String STRUTS_CONFIG_FILE_NAME = "webappos.xml";

	// TODO:後でpropertiesに移動。mapperファイル格納ディレクトリ
	/** MyBatisの設定ファイル名 */
	public static final String MYBATIS_CONFIG_FILE_NAME = "mybatis-config.xml";

	public static final String JSP_WORK_BASE_PATH = PROJECT_BASE_PATH + WEB_ROOT_DIR + System.getProperty("file.separator") + "work_" + JSP_DIR;;

	public static final String JSP_BASE_PATH = PROJECT_BASE_PATH + WEB_ROOT_DIR + System.getProperty("file.separator") + JSP_DIR;;

	public static final String CONFIG_FILE_PATH = PROJECT_BASE_PATH + PROPERTY_DIR + STRUTS_CONFIG_FILE_NAME;

	public static final String MYBATIS_CONFIG_FILE_PATH = PROJECT_BASE_PATH + PROPERTY_DIR + MYBATIS_CONFIG_FILE_NAME;

	public static final String MAPPER_BASE_PATH = PROJECT_BASE_PATH + MAPPER_DIR;

	/** 汎用Action名 */
	public static final String GENERIC_ACTION_NAME = "jp.co.headwaters.webappos.action.GenericAction";

	/** htmlファイルの拡張子 */
	public static final String[] HTML_EXTENSION =  { "html", "htm", "HTML", "HTM" };

	/** jspファイルの拡張子 */
	public static final String JSP_EXTENSION = "jsp";

	/** MyBatisのmapperファイルのサフィックス */
	public static final String MAPPER_SUFFIX = "-mapper.xml";



	public static final String FORM_ID_NAME = "formId";

	public static final String DATA_ATTRIBUTE_NAME_FUNC = "data-func";

	public static final String DATA_ATTRIBUTE_NAME_BIND = "data-bind";

	public static final String DATA_ATTRIBUTE_NAME_COND = "data-cond";

	public static final String DATA_ATTRIBUTE_NAME_SORT = "data-sort";

	public static final String DATA_ATTRIBUTE_NAME_ITERATOR = "data-iterator";

	public static final String DATA_ATTRIBUTE_NAME_CASE = "data-case";

	public static final String DATA_ATTRIBUTE_NAME_LOAD = "data-load";

	public static final String DATA_ATTRIBUTE_NAME_CONST = "data-const";


	public static final String STATEMENT_PREFIX = "dml";

	// for MyBatis 3
	public static final String MAPPER_DOCTYPE_NAME = "mapper";
	public static final String MAPPER_DOCTYPE_PUBLICID = "-//mybatis.org//DTD Mapper 3.0//EN";
	public static final String MAPPER_DOCTYPE_SYSTEMID = "http://mybatis.org/dtd/mybatis-3-mapper.dtd";

}
