package jp.co.headwaters.webappos;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import jp.co.headwaters.webappos.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.cache.SystemConstantCache;


public class AppilicationInitializer implements ServletContextListener {

	public void contextInitialized(ServletContextEvent event) {
		try {
			// キャッシュを更新する
			(new WebAppOSGenerator()).generate(event);

			// スキーマ情報をキャッシュする
			SchemaColumnCache schemaColumnCache = SchemaColumnCache.getInstance();
			schemaColumnCache.refresh();

			// system_constant情報をキャッシュする
			SystemConstantCache systemConstantCache = SystemConstantCache.getInstance();
			systemConstantCache.refresh();

		} catch (Exception e) {
			// Webアプリケーション起動を中止する
			throw new Error(e);
		}
	}

	public void contextDestroyed(ServletContextEvent event) {
		//Tomcatシャットダウン時処理
	}
}