/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.ResultExtractor;
import org.apache.ibatis.executor.loader.ProxyFactory;
import org.apache.ibatis.executor.loader.ResultLoader;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.ObjectTypeHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

public class FastResultSetHandler
implements ResultSetHandler {
    protected final Executor executor;
    protected final Configuration configuration;
    protected final MappedStatement mappedStatement;
    protected final RowBounds rowBounds;
    protected final ParameterHandler parameterHandler;
    protected final ResultHandler resultHandler;
    protected final BoundSql boundSql;
    protected final TypeHandlerRegistry typeHandlerRegistry;
    protected final ObjectFactory objectFactory;
    protected final ProxyFactory proxyFactory;
    protected final ResultExtractor resultExtractor;
    protected final Object OMIT = new Object();

    public FastResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        this.executor = executor;
        this.configuration = mappedStatement.getConfiguration();
        this.mappedStatement = mappedStatement;
        this.rowBounds = rowBounds;
        this.parameterHandler = parameterHandler;
        this.boundSql = boundSql;
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.objectFactory = this.configuration.getObjectFactory();
        this.resultHandler = resultHandler;
        this.proxyFactory = this.configuration.getProxyFactory();
        this.resultExtractor = new ResultExtractor(this.configuration, this.objectFactory);
    }

    @Override
    public void handleOutputParameters(CallableStatement cs) throws SQLException {
        Object parameterObject = this.parameterHandler.getParameterObject();
        MetaObject metaParam = this.configuration.newMetaObject(parameterObject);
        List<ParameterMapping> parameterMappings = this.boundSql.getParameterMappings();
        for (int i = 0; i < parameterMappings.size(); ++i) {
            ParameterMapping parameterMapping = parameterMappings.get(i);
            if (parameterMapping.getMode() != ParameterMode.OUT && parameterMapping.getMode() != ParameterMode.INOUT) continue;
            if (ResultSet.class.equals(parameterMapping.getJavaType())) {
                this.handleRefCursorOutputParameter((ResultSet)cs.getObject(i + 1), parameterMapping, metaParam);
                continue;
            }
            TypeHandler<?> typeHandler = parameterMapping.getTypeHandler();
            metaParam.setValue(parameterMapping.getProperty(), typeHandler.getResult(cs, i + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRefCursorOutputParameter(ResultSet rs, ParameterMapping parameterMapping, MetaObject metaParam) throws SQLException {
        try {
            String resultMapId = parameterMapping.getResultMapId();
            ResultMap resultMap = this.configuration.getResultMap(resultMapId);
            DefaultResultHandler resultHandler = new DefaultResultHandler(this.objectFactory);
            ResultColumnCache resultColumnCache = new ResultColumnCache(rs.getMetaData(), this.configuration);
            this.handleRowValues(rs, resultMap, resultHandler, new RowBounds(), resultColumnCache);
            metaParam.setValue(parameterMapping.getProperty(), resultHandler.getResultList());
        }
        finally {
            this.closeResultSet(rs);
        }
    }

    public List<Object> handleResultSets(Statement stmt) throws SQLException {
        ArrayList<Object> multipleResults = new ArrayList<Object>();
        List<ResultMap> resultMaps = this.mappedStatement.getResultMaps();
        int resultMapCount = resultMaps.size();
        int resultSetCount = 0;
        ResultSet rs = stmt.getResultSet();
        while (rs == null) {
            if (stmt.getMoreResults()) {
                rs = stmt.getResultSet();
                continue;
            }
            if (stmt.getUpdateCount() != -1) continue;
        }
        this.validateResultMapsCount(rs, resultMapCount);
        while (rs != null && resultMapCount > resultSetCount) {
            ResultMap resultMap = resultMaps.get(resultSetCount);
            ResultColumnCache resultColumnCache = new ResultColumnCache(rs.getMetaData(), this.configuration);
            this.handleResultSet(rs, resultMap, multipleResults, resultColumnCache);
            rs = this.getNextResultSet(stmt);
            this.cleanUpAfterHandlingResultSet();
            ++resultSetCount;
        }
        return this.collapseSingleResultList(multipleResults);
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void cleanUpAfterHandlingResultSet() {
    }

    protected void validateResultMapsCount(ResultSet rs, int resultMapCount) {
        if (rs != null && resultMapCount < 1) {
            throw new ExecutorException("A query was run and no Result Maps were found for the Mapped Statement '" + this.mappedStatement.getId() + "'.  It's likely that neither a Result Type nor a Result Map was specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResultSet(ResultSet rs, ResultMap resultMap, List<Object> multipleResults, ResultColumnCache resultColumnCache) throws SQLException {
        try {
            if (this.resultHandler == null) {
                DefaultResultHandler defaultResultHandler = new DefaultResultHandler(this.objectFactory);
                this.handleRowValues(rs, resultMap, defaultResultHandler, this.rowBounds, resultColumnCache);
                multipleResults.add(defaultResultHandler.getResultList());
            } else {
                this.handleRowValues(rs, resultMap, this.resultHandler, this.rowBounds, resultColumnCache);
            }
        }
        finally {
            this.closeResultSet(rs);
        }
    }

    protected List<Object> collapseSingleResultList(List<Object> multipleResults) {
        if (multipleResults.size() == 1) {
            List returned = (List)multipleResults.get(0);
            return returned;
        }
        return multipleResults;
    }

    protected void handleRowValues(ResultSet rs, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds, ResultColumnCache resultColumnCache) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rs, rowBounds);
        while (this.shouldProcessMoreRows(rs, resultContext, rowBounds)) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rs, resultMap, null);
            Object rowValue = this.getRowValue(rs, discriminatedResultMap, null, resultColumnCache);
            this.callResultHandler(resultHandler, resultContext, rowValue);
        }
    }

    protected void callResultHandler(ResultHandler resultHandler, DefaultResultContext resultContext, Object rowValue) {
        resultContext.nextResultObject(rowValue);
        resultHandler.handleResult(resultContext);
    }

    protected boolean shouldProcessMoreRows(ResultSet rs, ResultContext context, RowBounds rowBounds) throws SQLException {
        return !context.isStopped() && rs.next() && context.getResultCount() < rowBounds.getLimit();
    }

    protected void skipRows(ResultSet rs, RowBounds rowBounds) throws SQLException {
        if (rs.getType() != 1003) {
            if (rowBounds.getOffset() != 0) {
                rs.absolute(rowBounds.getOffset());
            }
        } else {
            for (int i = 0; i < rowBounds.getOffset(); ++i) {
                rs.next();
            }
        }
    }

    protected ResultSet getNextResultSet(Statement stmt) throws SQLException {
        try {
            if (stmt.getConnection().getMetaData().supportsMultipleResultSets() && (stmt.getMoreResults() || stmt.getUpdateCount() != -1)) {
                return stmt.getResultSet();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Object getRowValue(ResultSet rs, ResultMap resultMap, CacheKey rowKey, ResultColumnCache resultColumnCache) throws SQLException {
        ResultLoaderMap lazyLoader = this.instantiateResultLoaderMap();
        Object resultObject = this.createResultObject(rs, resultMap, lazyLoader, null, resultColumnCache);
        if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            List<String> mappedColumnNames;
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            boolean foundValues = resultMap.getConstructorResultMappings().size() > 0;
            if (this.shouldApplyAutomaticMappings(resultMap, !AutoMappingBehavior.NONE.equals((Object)this.configuration.getAutoMappingBehavior()))) {
                List<String> unmappedColumnNames = resultColumnCache.getUnmappedColumnNames(resultMap, null);
                foundValues = this.applyAutomaticMappings(rs, unmappedColumnNames, metaObject, null, resultColumnCache) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rs, resultMap, mappedColumnNames = resultColumnCache.getMappedColumnNames(resultMap, null), metaObject, lazyLoader, null) || foundValues;
            foundValues = lazyLoader != null && lazyLoader.size() > 0 || foundValues;
            resultObject = foundValues ? resultObject : null;
            return resultObject;
        }
        return resultObject;
    }

    protected boolean shouldApplyAutomaticMappings(ResultMap resultMap, boolean def) {
        if (resultMap.getAutoMapping() != null) {
            return resultMap.getAutoMapping();
        }
        return def;
    }

    protected ResultLoaderMap instantiateResultLoaderMap() {
        if (this.configuration.isLazyLoadingEnabled()) {
            return new ResultLoaderMap();
        }
        return null;
    }

    protected boolean applyPropertyMappings(ResultSet rs, ResultMap resultMap, List<String> mappedColumnNames, MetaObject metaObject, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        boolean foundValues = false;
        List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
        for (ResultMapping propertyMapping : propertyMappings) {
            String column = FastResultSetHandler.prependPrefix(propertyMapping.getColumn(), columnPrefix);
            if (!propertyMapping.isCompositeResult() && (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH)))) continue;
            Object value = this.getPropertyMappingValue(rs, metaObject, propertyMapping, lazyLoader, columnPrefix);
            String property = propertyMapping.getProperty();
            if (value == this.OMIT || property == null || value == null && !this.isCallSettersOnNulls(metaObject.getSetterType(property))) continue;
            metaObject.setValue(property, value);
            foundValues = value != null || foundValues;
        }
        return foundValues;
    }

    protected boolean isCallSettersOnNulls(Class<?> propertyType) {
        return this.configuration.isCallSettersOnNulls() && !propertyType.isPrimitive();
    }

    protected Object getPropertyMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        if (propertyMapping.getNestedQueryId() != null) {
            return this.getNestedQueryMappingValue(rs, metaResultObject, propertyMapping, lazyLoader, columnPrefix);
        }
        if (propertyMapping.getNestedResultMapId() != null) {
            return this.OMIT;
        }
        TypeHandler<?> typeHandler = propertyMapping.getTypeHandler();
        String column = FastResultSetHandler.prependPrefix(propertyMapping.getColumn(), columnPrefix);
        return typeHandler.getResult(rs, column);
    }

    protected boolean applyAutomaticMappings(ResultSet rs, List<String> unmappedColumnNames, MetaObject metaObject, String columnPrefix, ResultColumnCache resultColumnCache) throws SQLException {
        boolean foundValues = false;
        Iterator<String> i$ = unmappedColumnNames.iterator();
        while (i$.hasNext()) {
            TypeHandler<?> typeHandler;
            Object value;
            Class<?> propertyType;
            String property;
            String columnName;
            String propertyName = columnName = i$.next();
            if (columnPrefix != null && columnPrefix.length() > 0) {
                if (!columnName.startsWith(columnPrefix)) continue;
                propertyName = columnName.substring(columnPrefix.length());
            }
            if ((property = metaObject.findProperty(propertyName, this.configuration.isMapUnderscoreToCamelCase())) == null || !metaObject.hasSetter(property) || !this.typeHandlerRegistry.hasTypeHandler(propertyType = metaObject.getSetterType(property)) || (value = (typeHandler = resultColumnCache.getTypeHandler(propertyType, columnName)).getResult(rs, columnName)) == null && !this.isCallSettersOnNulls(propertyType)) continue;
            metaObject.setValue(property, value);
            foundValues = value != null || foundValues;
        }
        return foundValues;
    }

    protected Object createResultObject(ResultSet rs, ResultMap resultMap, ResultLoaderMap lazyLoader, String columnPrefix, ResultColumnCache resultColumnCache) throws SQLException {
        ArrayList constructorArgTypes = new ArrayList();
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        Object resultObject = this.createResultObject(rs, resultMap, constructorArgTypes, constructorArgs, columnPrefix, resultColumnCache);
        if (resultObject != null && this.configuration.isLazyLoadingEnabled() && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
            for (ResultMapping propertyMapping : propertyMappings) {
                if (propertyMapping.getNestedQueryId() == null) continue;
                return this.proxyFactory.createProxy(resultObject, lazyLoader, this.configuration, this.objectFactory, constructorArgTypes, constructorArgs);
            }
        }
        return resultObject;
    }

    protected Object createResultObject(ResultSet rs, ResultMap resultMap, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix, ResultColumnCache resultColumnCache) throws SQLException {
        Class<?> resultType = resultMap.getType();
        List<ResultMapping> constructorMappings = resultMap.getConstructorResultMappings();
        if (this.typeHandlerRegistry.hasTypeHandler(resultType)) {
            return this.createPrimitiveResultObject(rs, resultMap, columnPrefix, resultColumnCache);
        }
        if (constructorMappings.size() > 0) {
            return this.createParameterizedResultObject(rs, resultType, constructorMappings, constructorArgTypes, constructorArgs, columnPrefix, resultColumnCache);
        }
        return this.objectFactory.create(resultType);
    }

    protected Object createParameterizedResultObject(ResultSet rs, Class<?> resultType, List<ResultMapping> constructorMappings, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix, ResultColumnCache resultColumnCache) throws SQLException {
        boolean foundValues = false;
        for (ResultMapping constructorMapping : constructorMappings) {
            Object value;
            Class<?> parameterType = constructorMapping.getJavaType();
            String column = constructorMapping.getColumn();
            if (constructorMapping.getNestedQueryId() != null) {
                value = this.getNestedQueryConstructorValue(rs, constructorMapping, columnPrefix);
            } else if (constructorMapping.getNestedResultMapId() != null) {
                ResultMap resultMap = this.configuration.getResultMap(constructorMapping.getNestedResultMapId());
                ResultLoaderMap lazyLoader = this.instantiateResultLoaderMap();
                value = this.createResultObject(rs, resultMap, lazyLoader, columnPrefix, resultColumnCache);
            } else {
                TypeHandler<?> typeHandler = constructorMapping.getTypeHandler();
                value = typeHandler.getResult(rs, FastResultSetHandler.prependPrefix(column, columnPrefix));
            }
            constructorArgTypes.add(parameterType);
            constructorArgs.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues ? this.objectFactory.create(resultType, constructorArgTypes, constructorArgs) : null;
    }

    protected Object createPrimitiveResultObject(ResultSet rs, ResultMap resultMap, String columnPrefix, ResultColumnCache resultColumnCache) throws SQLException {
        String columnName;
        Class<?> resultType = resultMap.getType();
        if (resultMap.getResultMappings().size() > 0) {
            List<ResultMapping> resultMappingList = resultMap.getResultMappings();
            ResultMapping mapping = resultMappingList.get(0);
            columnName = FastResultSetHandler.prependPrefix(mapping.getColumn(), columnPrefix);
        } else {
            columnName = resultColumnCache.getColumnNames().get(0);
        }
        TypeHandler<?> typeHandler = resultColumnCache.getTypeHandler(resultType, columnName);
        return typeHandler.getResult(rs, columnName);
    }

    protected Object getNestedQueryConstructorValue(ResultSet rs, ResultMapping constructorMapping, String columnPrefix) throws SQLException {
        String nestedQueryId = constructorMapping.getNestedQueryId();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class<?> nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, constructorMapping, nestedQueryParameterType, columnPrefix);
        Object value = null;
        if (nestedQueryParameterObject != null) {
            BoundSql nestedBoundSql = nestedQuery.getBoundSql(nestedQueryParameterObject);
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT, nestedBoundSql);
            Class<?> targetType = constructorMapping.getJavaType();
            Object nestedQueryCacheObject = this.getNestedQueryCacheObject(nestedQuery, key);
            if (nestedQueryCacheObject != null && nestedQueryCacheObject instanceof List) {
                value = this.resultExtractor.extractObjectFromList((List)nestedQueryCacheObject, targetType);
            } else {
                ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, targetType, key, nestedBoundSql);
                value = resultLoader.loadResult();
            }
        }
        return value;
    }

    protected Object getNestedQueryMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        String nestedQueryId = propertyMapping.getNestedQueryId();
        String property = propertyMapping.getProperty();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class<?> nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, propertyMapping, nestedQueryParameterType, columnPrefix);
        Object value = this.OMIT;
        if (nestedQueryParameterObject != null) {
            BoundSql nestedBoundSql = nestedQuery.getBoundSql(nestedQueryParameterObject);
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT, nestedBoundSql);
            Class<?> targetType = propertyMapping.getJavaType();
            Object nestedQueryCacheObject = this.getNestedQueryCacheObject(nestedQuery, key);
            if (nestedQueryCacheObject != null && nestedQueryCacheObject instanceof List) {
                value = this.resultExtractor.extractObjectFromList((List)nestedQueryCacheObject, targetType);
            } else if (this.executor.isCached(nestedQuery, key)) {
                this.executor.deferLoad(nestedQuery, metaResultObject, property, key, targetType);
            } else {
                ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, targetType, key, nestedBoundSql);
                if (this.configuration.isLazyLoadingEnabled()) {
                    lazyLoader.addLoader(property, metaResultObject, resultLoader);
                } else {
                    value = resultLoader.loadResult();
                }
            }
        }
        return value;
    }

    private Object getNestedQueryCacheObject(MappedStatement nestedQuery, CacheKey key) {
        Cache nestedQueryCache = nestedQuery.getCache();
        return nestedQueryCache != null ? nestedQueryCache.getObject(key) : null;
    }

    protected Object prepareParameterForNestedQuery(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        if (resultMapping.isCompositeResult()) {
            return this.prepareCompositeKeyParameter(rs, resultMapping, parameterType, columnPrefix);
        }
        return this.prepareSimpleKeyParameter(rs, resultMapping, parameterType, columnPrefix);
    }

    protected Object prepareSimpleKeyParameter(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        TypeHandler<Object> typeHandler = this.typeHandlerRegistry.hasTypeHandler(parameterType) ? this.typeHandlerRegistry.getTypeHandler(parameterType) : this.typeHandlerRegistry.getUnknownTypeHandler();
        return typeHandler.getResult(rs, FastResultSetHandler.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    protected Object prepareCompositeKeyParameter(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        Object parameterObject = this.instantiateParameterObject(parameterType);
        MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
        boolean foundValues = false;
        for (ResultMapping innerResultMapping : resultMapping.getComposites()) {
            Class<?> propType = metaObject.getSetterType(innerResultMapping.getProperty());
            TypeHandler<?> typeHandler = this.typeHandlerRegistry.getTypeHandler(propType);
            Object propValue = typeHandler.getResult(rs, FastResultSetHandler.prependPrefix(innerResultMapping.getColumn(), columnPrefix));
            if (propValue == null) continue;
            metaObject.setValue(innerResultMapping.getProperty(), propValue);
            foundValues = true;
        }
        return foundValues ? parameterObject : null;
    }

    protected Object instantiateParameterObject(Class<?> parameterType) {
        if (parameterType == null) {
            return new HashMap();
        }
        return this.objectFactory.create(parameterType);
    }

    public ResultMap resolveDiscriminatedResultMap(ResultSet rs, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object value;
        String discriminatedMapId;
        HashSet<String> pastDiscriminators = new HashSet<String>();
        Discriminator discriminator = resultMap.getDiscriminator();
        while (discriminator != null && this.configuration.hasResultMap(discriminatedMapId = discriminator.getMapIdFor(String.valueOf(value = this.getDiscriminatorValue(rs, discriminator, columnPrefix))))) {
            resultMap = this.configuration.getResultMap(discriminatedMapId);
            Discriminator lastDiscriminator = discriminator;
            discriminator = resultMap.getDiscriminator();
            if (discriminator != lastDiscriminator && pastDiscriminators.add(discriminatedMapId)) continue;
            break;
        }
        return resultMap;
    }

    protected Object getDiscriminatorValue(ResultSet rs, Discriminator discriminator, String columnPrefix) throws SQLException {
        ResultMapping resultMapping = discriminator.getResultMapping();
        TypeHandler<?> typeHandler = resultMapping.getTypeHandler();
        return typeHandler.getResult(rs, FastResultSetHandler.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    protected static Set<String> prependPrefixes(Set<String> columnNames, String prefix) {
        if (columnNames == null || columnNames.isEmpty() || prefix == null || prefix.length() == 0) {
            return columnNames;
        }
        HashSet<String> prefixed = new HashSet<String>();
        for (String columnName : columnNames) {
            prefixed.add(FastResultSetHandler.prependPrefix(columnName, prefix));
        }
        return prefixed;
    }

    protected static String prependPrefix(String columnName, String prefix) {
        if (columnName == null || columnName.length() == 0) {
            return columnName;
        }
        if (prefix == null || prefix.length() == 0) {
            return columnName;
        }
        return prefix + columnName;
    }

    protected static class ResultColumnCache {
        private final TypeHandlerRegistry typeHandlerRegistry;
        private final List<String> columnNames = new ArrayList<String>();
        private final List<String> classNames = new ArrayList<String>();
        private final List<JdbcType> jdbcTypes = new ArrayList<JdbcType>();
        private final Map<String, Map<Class<?>, TypeHandler<?>>> typeHandlerMap = new HashMap();
        private Map<String, List<String>> mappedColumnNamesMap = new HashMap<String, List<String>>();
        private Map<String, List<String>> unMappedColumnNamesMap = new HashMap<String, List<String>>();

        protected ResultColumnCache(ResultSetMetaData metaData, Configuration configuration) throws SQLException {
            this.typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                this.columnNames.add(configuration.isUseColumnLabel() ? metaData.getColumnLabel(i) : metaData.getColumnName(i));
                this.jdbcTypes.add(JdbcType.forCode(metaData.getColumnType(i)));
                this.classNames.add(metaData.getColumnClassName(i));
            }
        }

        protected List<String> getColumnNames() {
            return this.columnNames;
        }

        protected JdbcType getJdbcType(String columnName) {
            int index = this.columnNames.indexOf(columnName);
            return this.jdbcTypes.get(index);
        }

        protected TypeHandler<?> getTypeHandler(Class<?> propertyType, String columnName) {
            TypeHandler<Object> handler = null;
            Map<Class<?>, TypeHandler<?>> columnHandlers = this.typeHandlerMap.get(columnName);
            if (columnHandlers == null) {
                columnHandlers = new HashMap();
                this.typeHandlerMap.put(columnName, columnHandlers);
            } else {
                handler = columnHandlers.get(propertyType);
            }
            if (handler == null) {
                handler = this.typeHandlerRegistry.getTypeHandler(propertyType);
                if (handler == null || handler instanceof UnknownTypeHandler) {
                    int index = this.columnNames.indexOf(columnName);
                    JdbcType jdbcType = this.jdbcTypes.get(index);
                    Class<?> javaType = this.resolveClass(this.classNames.get(index));
                    if (javaType != null && jdbcType != null) {
                        handler = this.typeHandlerRegistry.getTypeHandler(javaType, jdbcType);
                    } else if (javaType != null) {
                        handler = this.typeHandlerRegistry.getTypeHandler(javaType);
                    } else if (jdbcType != null) {
                        handler = this.typeHandlerRegistry.getTypeHandler(jdbcType);
                    }
                }
                if (handler == null || handler instanceof UnknownTypeHandler) {
                    handler = new ObjectTypeHandler();
                }
                columnHandlers.put(propertyType, handler);
            }
            return handler;
        }

        private Class<?> resolveClass(String className) {
            try {
                Class<?> clazz = Resources.classForName(className);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private void loadMappedAndUnmappedColumnNames(ResultMap resultMap, String columnPrefix) throws SQLException {
            ArrayList<String> mappedColumnNames = new ArrayList<String>();
            ArrayList<String> unmappedColumnNames = new ArrayList<String>();
            String upperColumnPrefix = columnPrefix == null ? null : columnPrefix.toUpperCase(Locale.ENGLISH);
            Set<String> mappedColumns = FastResultSetHandler.prependPrefixes(resultMap.getMappedColumns(), upperColumnPrefix);
            for (String columnName : this.columnNames) {
                String upperColumnName = columnName.toUpperCase(Locale.ENGLISH);
                if (mappedColumns.contains(upperColumnName)) {
                    mappedColumnNames.add(upperColumnName);
                    continue;
                }
                unmappedColumnNames.add(columnName);
            }
            this.mappedColumnNamesMap.put(this.getMapKey(resultMap, columnPrefix), mappedColumnNames);
            this.unMappedColumnNamesMap.put(this.getMapKey(resultMap, columnPrefix), unmappedColumnNames);
        }

        protected List<String> getMappedColumnNames(ResultMap resultMap, String columnPrefix) throws SQLException {
            List<String> mappedColumnNames = this.mappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
            if (mappedColumnNames == null) {
                this.loadMappedAndUnmappedColumnNames(resultMap, columnPrefix);
                mappedColumnNames = this.mappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
            }
            return mappedColumnNames;
        }

        protected List<String> getUnmappedColumnNames(ResultMap resultMap, String columnPrefix) throws SQLException {
            List<String> unMappedColumnNames = this.unMappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
            if (unMappedColumnNames == null) {
                this.loadMappedAndUnmappedColumnNames(resultMap, columnPrefix);
                unMappedColumnNames = this.unMappedColumnNamesMap.get(this.getMapKey(resultMap, columnPrefix));
            }
            return unMappedColumnNames;
        }

        private String getMapKey(ResultMap resultMap, String columnPrefix) {
            return resultMap.getId() + ":" + columnPrefix;
        }
    }
}

