/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.profiling;

import com.opensymphony.xwork2.util.profiling.TimerInvocationHandler;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ObjectProfiler {
    public static Object getProfiledObject(Class interfaceClazz, Object o) {
        if (!UtilTimerStack.isActive()) {
            return o;
        }
        if (interfaceClazz.isInterface()) {
            TimerInvocationHandler timerHandler = new TimerInvocationHandler(o);
            return Proxy.newProxyInstance(interfaceClazz.getClassLoader(), new Class[]{interfaceClazz}, (InvocationHandler)timerHandler);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object profiledInvoke(Method target, Object value, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (!UtilTimerStack.isActive()) {
            return target.invoke(value, args);
        }
        String logLine = new String(ObjectProfiler.getTrimmedClassName(target) + "." + target.getName() + "()");
        UtilTimerStack.push(logLine);
        try {
            Object returnValue = target.invoke(value, args);
            if (returnValue != null && target.getReturnType().isInterface()) {
                TimerInvocationHandler timerHandler = new TimerInvocationHandler(returnValue);
                Object object = Proxy.newProxyInstance(returnValue.getClass().getClassLoader(), new Class[]{target.getReturnType()}, (InvocationHandler)timerHandler);
                return object;
            }
            Object object = returnValue;
            return object;
        }
        finally {
            UtilTimerStack.pop(logLine);
        }
    }

    public static String getTrimmedClassName(Method method) {
        String classname = method.getDeclaringClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }
}

