/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.config.providers.DirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleDetector<T> {
    private static final String marked = "marked";
    private static final String complete = "complete";
    private DirectedGraph<T> graph;
    private Map<T, String> marks;
    private List<T> verticesInCycles;

    public CycleDetector(DirectedGraph<T> graph) {
        this.graph = graph;
        this.marks = new HashMap<T, String>();
        this.verticesInCycles = new ArrayList<T>();
    }

    public boolean containsCycle() {
        for (T v : this.graph) {
            if (!this.marks.containsKey(v) && !this.mark(v)) continue;
        }
        return !this.verticesInCycles.isEmpty();
    }

    private boolean mark(T vertex) {
        ArrayList<T> localCycles = new ArrayList<T>();
        this.marks.put(vertex, marked);
        for (T u : this.graph.edgesFrom(vertex)) {
            if (this.marks.containsKey(u) && this.marks.get(u).equals(marked)) {
                localCycles.add(vertex);
                continue;
            }
            if (this.marks.containsKey(u) || !this.mark(u)) continue;
            localCycles.add(vertex);
        }
        this.marks.put(vertex, complete);
        this.verticesInCycles.addAll(localCycles);
        return !localCycles.isEmpty();
    }

    public List<T> getVerticesInCycles() {
        return this.verticesInCycles;
    }
}

