/*
 * Copyright (C) 2011-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;

public class TABLE extends AbstractTable {
    public TABLE(Writer writer, Attr... attr) throws IOException {
        super(writer, "table", attr);
    }
    public CAPTION caption(Attr... attr) throws IOException {
        return new CAPTION(writer, attr);
    }
    // 特殊な使いかたをするので、特殊メソッド
    public void col(String clazz) throws IOException {
        writer.write("<col class=\"");
        writer.write(clazz);
        writer.write("\"/>");
    }
    public TBODY tbody(Attr... attr) throws IOException {
        return new TBODY(writer, attr);
    }
    public THEAD thead(Attr... attr) throws IOException {
        return new THEAD(writer, attr);
    }
    public TFOOT tfoot(Attr... attr) throws IOException {
        return new TFOOT(writer, attr);
    }
}
