package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public abstract class AbstractForm extends AbstractBody {
    public AbstractForm(Writer writer, String elementName, Attr... attr) throws IOException {
        super(writer, elementName, attr);
    }
    public FIELDSET fieldset(Attr... attr) throws IOException {
        return new FIELDSET(writer, attr);
    }
    public LABEL label(Attr... attr) throws IOException {
        return new LABEL(writer, attr);
    }
    private void input(String type, String name, String value, Attr... attr) throws IOException {
        writer.write("<input type=\"");
        writer.write(type);
        writer.write("\" name=\"");
        writer.write(name);
        writer.write("\"");
        if(value != null) {
            writer.write(" value=\"");
            writer.write(value);
            writer.write("\"");
        }
        Attr.output(writer, attr);
        writer.write(">");
    }
    public void inputHidden(String name, String value) throws IOException {
        input("hidden", name, value);
    }
    public void inputText(String name, String value, Attr... attr) throws IOException {
        input("text", name, value, attr);
    }
    /**
     * 
     * @param name
     * @param value
     * @param attr AttrTEXTの属性が指定できる
     * @throws IOException 
     */
    public void inputSearch(String name, String value, Attr... attr) throws IOException {
        input("search", name, value, attr);
    }
    public void inputTel(String name, String value, Attr... attr) throws IOException {
        input("tel", name, value, attr);
    }
    public void inputUrl(String name, String value, Attr... attr) throws IOException {
        input("url", name, value, attr);
    }
    public void inputEmail(String name, String value, Attr... attr) throws IOException {
        input("email", name, value);
        // TODO:multipleという属性を指定できる
    }
    public void inputPassword(String name, String value, Attr... attr) throws IOException {
        input("password", name, value, attr);
    }
    public void inputDateTime(String name, String value, Attr... attr) throws IOException {
        input("datetime", name, value, attr);
        // TODO:step, max, minという属性を指定できる
    }
    public void inputDate(String name, String value, Attr... attr) throws IOException {
        input("date", name, value, attr);
        // TODO:step, max, min属性
    }
    public void inputMonth(String name, String value, Attr... attr) throws IOException {
        input("month", name, value, attr);
    }
    public void inputWeek(String name, String value, Attr... attr) throws IOException {
        input("week", name, value, attr);
    }
    public void inputTime(String name, String value, Attr... attr) throws IOException {
        input("time", name, value, attr);
    }
    public void inputDateTimeLocal(String name, String value, Attr... attr) throws IOException {
        input("datetime-local", name, value, attr);
    }
    public void inputNumber(String name, String value, Attr... attr) throws IOException {
        input("number", name, value, attr);
    }
    public void inputRange(String name, String value, Attr... attr) throws IOException {
        input("range", name, value, attr);
    }
    public void inputColor(String name, String value, Attr... attr) throws IOException {
        input("color", name, value, attr);
    }
    public void inputCheckBox(String name, String value, Attr... attr) throws IOException {
        input("checkbox", name, value, attr);
    }
    public void inputRadio(String name, String value, Attr... attr) throws IOException {
        input("radio", name, value, attr);
    }
    public void inputFile(String name, Attr... attr) throws IOException {
        input("file", name, null, attr);
    }
    public void inputSubmit(String name, String value, Attr... attr) throws IOException {
        input("submit", name, value, attr);
        // TODO:ちょっとカスタマイズした方が良いかも。
    }
    public void inputImage(String name, String src, String alt, String value, Attr... attr) throws IOException {
//        input("image", name, null, Attr.src(src), Attr.alt(alt), attr);
    }
    
    public void button() {
        
    }
    // TODO:将来的にはoptgroupとselectedに対応できるようにする
    public void datalist(String id, Collection<?> list) throws IOException {
        writer.write("<datalist id=\"");
        writer.write(id);
        writer.write("\">");
        for(Object data : list) {
            writer.write("<option value=\"");
            writer.write(data.toString());
            writer.write("\">");
        }
        writer.write("</datalist>");
    }
    public void textArea(String name, String value, Attr... attr) throws IOException {
        writer.write("<textarea name=\"");
        writer.write(name);
        writer.write("\"");
        Attr.output(writer, attr);
        writer.write(">");
        writer.write(value); // TODO:CDATA化やエスケープなど？
        writer.write("</textarea>");
    }
}
