/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.List;
import javax.inject.Inject;

public class SQLQuery implements AutoCloseable {
    private Connection conn;
    private PreparedStatement stmt;
    private String sessionID;
    
    @Inject
    public SQLQuery(Connection conn, String sessionID) {
        this.conn = conn;
        this.sessionID = sessionID;
    }
    @Override
    public void close() throws SQLException {
        if(stmt != null) {
            stmt.close();
            stmt = null;
        }
        if(conn != null) {
            conn.close();
            conn = null;
        }
    }
    public ResultSet executeQuery(String sql, Object... args) throws SQLException {
        SQLLog log = new SQLLog(sessionID);
        log.begin(sql);
        try {
            stmt = conn.prepareStatement(sql);
            int index = 1;
            for (Object obj : args) {
                if (obj == null) {
                    log.paramlog(index, "NULL");
                    stmt.setNull(index++, Types.NULL); // NULLで良いの？
                } else {
                    log.paramlog(index, obj.toString());
                    stmt.setObject(index++, obj);
                }
            }
            return stmt.executeQuery();
        }
        finally {
            log.end();
        }
    }
    public ResultSet executeQuery(String sql, List<SQLWhere> wheres) throws SQLException {
        SQLLog log = new SQLLog(sessionID);

        StringBuilder sb = new StringBuilder(sql);
        if(wheres.size() > 0) {
            boolean first = true;
            sb.append(" WHERE ");
            for(SQLWhere where : wheres) {
                if(first == false) {
                    sb.append(" AND ");
                }
                sb.append(where.getWhere());
            }
        }
        sql = sb.toString();
        log.begin(sql);
        try {
            stmt = conn.prepareStatement(sql);
            int index = 1;
            for(SQLWhere where : wheres) {
                for(Object obj : where.getValues()) {
                    if(obj == null) {
                        log.paramlog(index, "NULL");
                        stmt.setNull(index++, Types.NULL);
                    } else {
                        log.paramlog(index, obj.toString());
                        stmt.setObject(index++, obj);
                    }
                }
            }
            return stmt.executeQuery();
        }
        finally {
            log.end();
        }
    }
}
