/*
 * Copyright (C) 2007-2011 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.util.Date;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLLog {
    private static Logger log = LoggerFactory.getLogger("org.infodb.wax.core.sql");
    
    private String sessionID;
    private long beginTime;
    
    @Inject
    public SQLLog(String sessionID) {
        this.sessionID = sessionID;
    }
    public void begin(String sql) {
        Date dt = new Date();
        beginTime = dt.getTime();
        if (log.isDebugEnabled()) {
            StringBuilder sb = buildCommonHeader();
            sb.append(sql.replace("\n", " ").replace("\t", " "));
            log.debug(sb.toString());
        }
    }
    public void paramlog(int index, String param) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = buildCommonHeader();
            sb.append("param").append(index).append(":").append(param);
            log.trace(sb.toString());
        }
    }
    public void wherelog(int index, String where) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = buildCommonHeader();
            sb.append("where").append(index).append(":").append(where);
            log.trace(sb.toString());
        }
    }
    public void error(Throwable t) {
        StringBuilder sb = buildCommonHeader();
        sb.append(t.getMessage());
        log.error(sb.toString(), t);
    }
    public void end() {
        if (log.isDebugEnabled()) {
            Date dt = new Date();
            long delta = dt.getTime() - beginTime;
            StringBuilder sb = buildCommonHeader();
            sb.append("Execution Time=").append(delta).append("ms");
            log.debug(sb.toString());
        }
    }
    private StringBuilder buildCommonHeader() {
        StringBuilder sb = new StringBuilder("sql:(");
        if(sessionID != null) {
            sb.append(sessionID).append(":");
        }
        sb.append(beginTime);
        sb.append("):");
        return sb;
    }
    
}
