/*
 * Copyright (C) 2011 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.text.MessageFormat;

public class DefOracle implements Definition {
    private static final String[] TYPE_ORACLE = {"CHAR","VARCHAR2","NUMERIC","DATE","DATE","DATE", "CLOB","BLOB","XMLType", "PURGE", " NULL"};
    private BindClobResolver adapter = new BindClobResolver();
    
    @Override
    public String[] getTypes() {
        return TYPE_ORACLE;
    }
    @Override
    public String getSelectXmlCol(String colName) {
        return MessageFormat.format("{0}.getClobVal()", new Object[] { colName });
    }
    @Override
    public String getUpdateXmlCol() {
        return "XMLType(?)";
    }
    @Override
    public String getCurDateFunc() {
        return "sysdate";
    
    }
    @Override
    public BindResolver getAdapter() {
        return adapter;
    }
}
