/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core;

import java.io.IOException;
import org.infodb.wax.core.html.AbstractBody;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * XmlQueryで読み込んだWIKIページをWikiProcessorで処理するクラス。
 * WikiDispatcherの処理。
 */
public class WikiWriter implements ContentHandler {
    private WikiProcessor processor;
    private HTMLBuilder builder;
    private AbstractBody body;
    private boolean wikiMode;
    
    public WikiWriter(WikiProcessor processor, HTMLBuilder builder) {
        this.processor = processor;
        this.builder = builder;
        wikiMode = false;
    }
    @Override
    public void setDocumentLocator(Locator locator) {
    }
    @Override
    public void startDocument() throws SAXException {
    }
    @Override
    public void endDocument() throws SAXException {
    }
    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if(localName.equals("wiki")) {
            wikiMode = true;
            if(body == null) {
                try {
                    body = builder.next(null);
                } catch (IOException ex) {
                    throw new SAXException(ex);
                }
            }
        }
    }
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if(localName.equals("wiki")) {
            wikiMode = false;
        }
    }
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if(wikiMode == true) {
            try {
                processor.parse(new String(ch, start, length), body);
            } catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }
    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }
    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }
    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}
